/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import javax.vecmath.Color4f;
import org.j3d.util.ColorUtils;
import org.j3d.util.interpolator.Interpolator;

public class ColorInterpolator
extends Interpolator {
    private static final String INVALID_H_MSG = "Invalid h (it has a value) value when s is zero";
    public static final int HSV_SPACE = 1;
    public static final int RGB_SPACE = 2;
    private Color4f sharedColor;
    private float[] sharedVector;
    private float[][] keyValues;
    private int colorSpace;

    public ColorInterpolator() {
        this(20, 2, 1);
    }

    public ColorInterpolator(int n) {
        this(n, 2, 1);
    }

    public ColorInterpolator(int n, int n2) {
        this(n, n2, 1);
    }

    public ColorInterpolator(int n, int n2, int n3) {
        super(n, n3);
        this.keys = new float[n];
        this.keyValues = new float[n][4];
        this.sharedColor = new Color4f();
        this.sharedVector = new float[4];
        this.colorSpace = n2;
    }

    public void addRGBKeyFrame(float f, float f2, float f3, float f4, float f5) {
        if (this.colorSpace == 1) {
            this.convertRGBtoHSV(f2, f3, f4);
            this.addKeyFrame(f, this.sharedVector[0], this.sharedVector[1], this.sharedVector[2], f5);
        } else {
            this.addKeyFrame(f, f2, f3, f4, f5);
        }
    }

    public void addHSVKeyFrame(float f, float f2, float f3, float f4, float f5) {
        if (this.colorSpace == 2) {
            this.convertHSVtoRGB(f2, f3, f4);
            this.addKeyFrame(f, this.sharedVector[0], this.sharedVector[1], this.sharedVector[2], f5);
        } else {
            if (f3 == 0.0f && !Float.isNaN(f2)) {
                throw new IllegalArgumentException(INVALID_H_MSG);
            }
            this.addKeyFrame(f, f2, f3, f4, f5);
        }
    }

    public void addRGBKeyFrame(float f, Color4f color4f) {
        this.addRGBKeyFrame(f, color4f.x, color4f.y, color4f.z, color4f.w);
    }

    public void addHSVKeyFrame(float f, Color4f color4f) {
        this.addHSVKeyFrame(f, color4f.x, color4f.y, color4f.z, color4f.w);
    }

    public float[] floatRGBValue(float f) {
        this.floatValue(f);
        if (this.colorSpace == 1) {
            this.convertHSVtoRGB(this.sharedVector[0], this.sharedVector[1], this.sharedVector[2]);
        }
        return this.sharedVector;
    }

    public Color4f pointRGBValue(float f) {
        this.floatValue(f);
        if (this.colorSpace == 1) {
            this.convertHSVtoRGB(this.sharedVector[0], this.sharedVector[1], this.sharedVector[2]);
        }
        this.sharedColor.x = this.sharedVector[0];
        this.sharedColor.y = this.sharedVector[1];
        this.sharedColor.z = this.sharedVector[2];
        this.sharedColor.w = this.sharedVector[3];
        return this.sharedColor;
    }

    public float[] floatHSVValue(float f) {
        this.floatValue(f);
        if (this.colorSpace == 2) {
            this.convertRGBtoHSV(this.sharedVector[0], this.sharedVector[1], this.sharedVector[2]);
        }
        return this.sharedVector;
    }

    public Color4f pointHSVValue(float f) {
        this.floatValue(f);
        if (this.colorSpace == 2) {
            this.convertRGBtoHSV(this.sharedVector[0], this.sharedVector[1], this.sharedVector[2]);
        }
        this.sharedColor.x = this.sharedVector[0];
        this.sharedColor.y = this.sharedVector[1];
        this.sharedColor.z = this.sharedVector[2];
        this.sharedColor.w = this.sharedVector[3];
        return this.sharedColor;
    }

    private void convertRGBtoHSV(float f, float f2, float f3) {
        ColorUtils.convertRGBtoHSV(f, f2, f3, this.sharedVector);
    }

    private void convertHSVtoRGB(float f, float f2, float f3) {
        ColorUtils.convertHSVtoRGB(f, f2, f3, this.sharedVector);
    }

    private void addKeyFrame(float f, float f2, float f3, float f4, float f5) {
        float[] fArray;
        int n = this.findKeyIndex(f);
        if (n < 0) {
            n = 0;
        }
        while (n < this.currentSize && this.keys[n] <= f) {
            ++n;
        }
        this.realloc();
        if (n >= this.currentSize) {
            fArray = this.keyValues[this.currentSize];
        } else {
            int n2 = this.currentSize - n;
            System.arraycopy(this.keyValues, n, this.keyValues, n + 1, n2);
            System.arraycopy(this.keys, n, this.keys, n + 1, n2);
            fArray = new float[4];
            this.keyValues[n] = fArray;
        }
        fArray[0] = f2;
        fArray[1] = f3;
        fArray[2] = f4;
        fArray[3] = f5;
        this.keys[n] = f;
        ++this.currentSize;
    }

    private void floatValue(float f) {
        int n = this.findKeyIndex(f);
        if (n < 0) {
            this.sharedVector[0] = this.keyValues[0][0];
            this.sharedVector[1] = this.keyValues[0][1];
            this.sharedVector[2] = this.keyValues[0][2];
            this.sharedVector[3] = this.keyValues[0][3];
        } else if (n >= this.currentSize - 1) {
            this.sharedVector[0] = this.keyValues[this.currentSize - 1][0];
            this.sharedVector[1] = this.keyValues[this.currentSize - 1][1];
            this.sharedVector[2] = this.keyValues[this.currentSize - 1][2];
            this.sharedVector[3] = this.keyValues[this.currentSize - 1][3];
        } else {
            switch (this.interpolationType) {
                case 1: {
                    float[] fArray = this.keyValues[n + 1];
                    float[] fArray2 = this.keyValues[n];
                    float f2 = fArray2[0];
                    float f3 = fArray[0];
                    if (this.colorSpace == 1) {
                        if (Float.isNaN(f2) && !Float.isNaN(f3)) {
                            f2 = f3;
                        } else if (!Float.isNaN(f2) && Float.isNaN(f3)) {
                            f3 = f2;
                        }
                    }
                    float f4 = f3 - f2;
                    float f5 = fArray[1] - fArray2[1];
                    float f6 = fArray[2] - fArray2[2];
                    float f7 = fArray[3] - fArray2[3];
                    float f8 = 0.0f;
                    float f9 = this.keys[n + 1];
                    float f10 = this.keys[n];
                    if (f9 != f10) {
                        f8 = (f - f10) / (f9 - f10);
                    }
                    this.sharedVector[0] = f2 + f8 * f4;
                    this.sharedVector[1] = fArray2[1] + f8 * f5;
                    this.sharedVector[2] = fArray2[2] + f8 * f6;
                    this.sharedVector[3] = fArray2[3] + f8 * f7;
                    break;
                }
                case 2: {
                    float[] fArray = this.keyValues[n];
                    this.sharedVector[0] = fArray[0];
                    this.sharedVector[1] = fArray[1];
                    this.sharedVector[2] = fArray[2];
                    this.sharedVector[3] = fArray[3];
                }
            }
        }
    }

    private final void realloc() {
        if (this.currentSize == this.allocatedSize) {
            int n = this.allocatedSize + 5;
            float[][] fArrayArray = new float[n][];
            System.arraycopy(this.keyValues, 0, fArrayArray, 0, this.allocatedSize);
            for (int i = this.allocatedSize; i < n; ++i) {
                fArrayArray[i] = new float[4];
            }
            float[] fArray = new float[n];
            System.arraycopy(this.keys, 0, fArray, 0, this.allocatedSize);
            this.keys = fArray;
            this.keyValues = fArrayArray;
            this.allocatedSize = n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<color interpolator>\n");
        for (int i = 0; i < this.currentSize; ++i) {
            stringBuffer.append(i);
            stringBuffer.append(" key: ");
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(" h: ");
            stringBuffer.append(this.keyValues[i][0]);
            stringBuffer.append(" s: ");
            stringBuffer.append(this.keyValues[i][1]);
            stringBuffer.append(" v: ");
            stringBuffer.append(this.keyValues[i][2]);
            stringBuffer.append(" a: ");
            stringBuffer.append(this.keyValues[i][3]);
            stringBuffer.append("\n");
        }
        stringBuffer.append("</color interpolator>");
        return stringBuffer.toString();
    }
}

