/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLSurfaceUtils.txx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See LICENSE or http://www.apache.org/licenses/LICENSE-2.0 for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLSurfaceUtils_txx
#define vtkPCLSurfaceUtils_txx

#include <vtkPolyData.h>

#include "vtkPCLSurfaceUtils.h"
#include "vtkPCLUtils.h"

//-----------------------------------------------------------------------------
template <typename PointT>
vtkSmartPointer<vtkPolyData> vtkPCLSurfaceUtils::CreateVTKPolygons(PointTPtr<PointT> pointcloud,
  std::vector<pcl::Vertices>& polygons)
{
  vtkNew<vtkPolyData> output;
  // Convert outputCloud data in vtk format
  vtkPCLUtils::PointCloudToPolyData(*pointcloud, output);
  // Remove vertices from output
  output->SetVerts(nullptr);
  return vtkPCLSurfaceUtils::CreateVTKPolygons(output, polygons);
}

#endif // vtkPCLSurfaceUtils_txx
