/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLSurfaceUtils.h

  Copyright (c) Kitware Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLSurfaceUtils_h
#define vtkPCLSurfaceUtils_h

// vtk includes
#include <vtkPolyDataAlgorithm.h>

// pcl includes
#include <pcl/Vertices.h>
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>

#include "vtkPCLSurfaceModule.h" // for export macro

/**
 * @brief The vtkPCLSurfaceUtils class provides convenient functions for PCL surface wrapped in VTK.
 */
class VTKPCLSURFACE_EXPORT vtkPCLSurfaceUtils : public vtkObject
{
  template <typename PointT>
  using PointTPtr = typename pcl::PointCloud<PointT>::Ptr;

public:
  static vtkPCLSurfaceUtils* New();

  vtkTypeMacro(vtkPCLSurfaceUtils, vtkObject);

  ///@{
  /**
   * Creates a vtkPolyData mesh from a point cloud and a list of polygons.
   */
  template <typename PointT>
  static vtkSmartPointer<vtkPolyData> CreateVTKPolygons(PointTPtr<PointT> pointcloud,
    std::vector<pcl::Vertices>& polygons);
  static vtkSmartPointer<vtkPolyData> CreateVTKPolygons(vtkPolyData* pointCloud,
    std::vector<pcl::Vertices>& polygons);
  ///@}

protected:
  // constructor / destructor
  vtkPCLSurfaceUtils() = default;
  ~vtkPCLSurfaceUtils() = default;

private:
  // copy operators
  vtkPCLSurfaceUtils(const vtkPCLSurfaceUtils&);
  void operator=(const vtkPCLSurfaceUtils&);
};

#include "vtkPCLSurfaceUtils.txx" // for template implementations

#endif // vtkPCLSurfaceUtils_h
