/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLConvexHull.h

  Copyright (c) Kitware Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLConvexHull_h
#define vtkPCLConvexHull_h

// vtk includes
#include <vtkPolyDataAlgorithm.h>

// pcl includes
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>

#include "vtkPCLSurfaceModule.h" // for export macro

/**
 * @brief The vtkPCLConvexHull class implements a convex hull reconstruction algorithm. This filter
 * wraps the ConvexHull class from the PCL library.
 */
class VTKPCLSURFACE_EXPORT vtkPCLConvexHull : public vtkPolyDataAlgorithm
{
public:
  static vtkPCLConvexHull* New();
  vtkTypeMacro(vtkPCLConvexHull, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

protected:
  vtkPCLConvexHull() = default;
  ~vtkPCLConvexHull() = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

private:
  vtkPCLConvexHull(const vtkPCLConvexHull&);
  void operator=(const vtkPCLConvexHull&);
};

#endif // vtkPCLConvexHull_h
