/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLConvexHull.cxx

  Copyright (c) Kitware Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// local includes
#include "vtkPCLConvexHull.h"
#include "vtkPCLSurfaceUtils.h"
#include "vtkPCLUtils.h"

// pcl includes
#include <pcl/surface/convex_hull.h>

// vtk includes
#include <vtkInformation.h>
#include <vtkInformationVector.h>
#include <vtkPolyData.h>

//-----------------------------------------------------------------------------
vtkStandardNewMacro(vtkPCLConvexHull);

//-----------------------------------------------------------------------------
void vtkPCLConvexHull::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

//-----------------------------------------------------------------------------
int vtkPCLConvexHull::RequestData(vtkInformation* vtkNotUsed(request),
  vtkInformationVector** inputVector,
  vtkInformationVector* outputVector)
{
  // Get the input
  vtkPolyData* input = vtkPolyData::GetData(inputVector[0]->GetInformationObject(0));
  // Convert the input data to PCL format
  pcl::PointCloud<pcl::PointXYZ>::Ptr pointCloud(new pcl::PointCloud<pcl::PointXYZ>);
  vtkPCLUtils::PolyDataToPointCloud(input, *pointCloud);

  pcl::PointCloud<pcl::PointXYZ>::Ptr outputCloud(new pcl::PointCloud<pcl::PointXYZ>);

  // Apply reconstruction
  pcl::ConvexHull<pcl::PointXYZ> filter;
  filter.setInputCloud(pointCloud);
  std::vector<pcl::Vertices> polygons;
  filter.reconstruct(*outputCloud, polygons);

  vtkPolyData* output = vtkPolyData::GetData(outputVector->GetInformationObject(0));
  // Convert the output to a vtkPolyData mesh
  output->ShallowCopy(vtkPCLSurfaceUtils::CreateVTKPolygons<pcl::PointXYZ>(outputCloud, polygons));

  return 1;
}
