/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLConcaveHull.h

  Copyright (c) Kitware Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLConcaveHull_h
#define vtkPCLConcaveHull_h

// vtk includes
#include <vtkPolyDataAlgorithm.h>

// pcl includes
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>

#include "vtkPCLSurfaceModule.h" // for export macro

/**
 * @brief The vtkPCLConcaveHull class implements a concave hull reconstruction algorithm. This
 * filter wraps the ConcaveHull class from the PCL library.
 */
class VTKPCLSURFACE_EXPORT vtkPCLConcaveHull : public vtkPolyDataAlgorithm
{
public:
  static vtkPCLConcaveHull* New();
  vtkTypeMacro(vtkPCLConcaveHull, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  vtkGetMacro(Alpha, double);
  vtkSetMacro(Alpha, double);

protected:
  vtkPCLConcaveHull() = default;
  ~vtkPCLConcaveHull() = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

  // Limits the size of the resultant hull segments (the smaller the more detailed the hull).
  double Alpha = 0.1;

private:
  vtkPCLConcaveHull(const vtkPCLConcaveHull&);
  void operator=(const vtkPCLConcaveHull&);
};

#endif // vtkPCLConcaveHull_h
