/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLSegmentationUtils.txx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See LICENSE or http://www.apache.org/licenses/LICENSE-2.0 for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLSegmentationUtils_txx
#define vtkPCLSegmentationUtils_txx

// Local includes
#include "vtkPCLUtils.h"

// VTK includes
#include <vtkDataArray.h>
#include <vtkFloatArray.h>
#include <vtkPointData.h>
#include <vtkPolyData.h>

#include "vtkPCLSegmentationUtils.h" // For export macro

//-----------------------------------------------------------------------------
template <typename PointT>
void vtkPCLSegmentationUtils::RetreiveVTKNormalsOrCompute(vtkPolyData* input,
  double searchRadius,
  PointTPtr<PointT> pointCloud,
  pcl::PointCloud<pcl::Normal>::Ptr cloudNormals)
{
  vtkSmartPointer<vtkDataArray> normals = input->GetPointData()->GetNormals();
  if (normals)
  {
    vtkSmartPointer<vtkFloatArray> floatNormals = vtkFloatArray::SafeDownCast(normals);
    if (floatNormals)
    {
      cloudNormals->resize(input->GetNumberOfPoints());
      for (int i = 0; i < input->GetNumberOfPoints(); i++)
      {
        pcl::Normal normal;
        normal.normal_x = floatNormals->GetComponent(i, 0);
        normal.normal_y = floatNormals->GetComponent(i, 1);
        normal.normal_z = floatNormals->GetComponent(i, 2);
        cloudNormals->at(i) = normal;
      }
    }
  }
  else
  {
    vtkPCLUtils::EstimatePCLNormals<PointT>(pointCloud, searchRadius, cloudNormals);
  }
}

#endif // vtkPCLSegmentationUtils_txx
