/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLSegmentationUtils.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See LICENSE or http://www.apache.org/licenses/LICENSE-2.0 for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLSegmentationUtils_h
#define vtkPCLSegmentationUtils_h

// VTK includes
#include <vtkPolyDataAlgorithm.h>

// PCL includes
#include <pcl/PointIndices.h>
#include <pcl/common/common.h>
#include <pcl/point_types.h>

#include "vtkPCLSegmentationModule.h" // For export macro

/**
 * @brief The vtkPCLSegmentationUtils class provides convenient functions for PCL segmentation
 * wrapped in VTK.
 */
class VTKPCLSEGMENTATION_EXPORT vtkPCLSegmentationUtils : public vtkObject
{
  template <typename PointT>
  using PointTPtr = typename pcl::PointCloud<PointT>::Ptr;

public:
  static vtkPCLSegmentationUtils* New();
  vtkTypeMacro(vtkPCLSegmentationUtils, vtkObject);

  /**
   * @brief SetIndices Set the indices of the clusters in the output
   */
  static void SetIndices(vtkPolyData* output, std::vector<pcl::PointIndices> clusterIndices);

  /**
   * @brief Check if normals are already computed in vtkPolyData input:
   *  - If they are present convert them to pcl format in cloudNormals
   *  - Otherwise compute a kdtree using searchRadius to compute normals
   */
  template <typename PointT>
  static void RetreiveVTKNormalsOrCompute(vtkPolyData* input,
    double searchRadius,
    PointTPtr<PointT> pointCloud,
    pcl::PointCloud<pcl::Normal>::Ptr cloudNormals);

protected:
  vtkPCLSegmentationUtils() = default;
  ~vtkPCLSegmentationUtils() = default;

private:
  vtkPCLSegmentationUtils(const vtkPCLSegmentationUtils&);
  void operator=(const vtkPCLSegmentationUtils&);
};

#include "vtkPCLSegmentationUtils.txx" // for template implementations

#endif // vtkPCLSegmentationUtils_h
