/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLSegmentationUtils.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See LICENSE or http://www.apache.org/licenses/LICENSE-2.0 for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// Local includes
#include "vtkPCLSegmentationUtils.h"

// VTK includes
#include <vtkPointData.h>
#include <vtkSMPTools.h>
#include <vtkUnsignedIntArray.h>

//----------------------------------------------------------------------------
vtkStandardNewMacro(vtkPCLSegmentationUtils);

//-----------------------------------------------------------------------------
void vtkPCLSegmentationUtils::SetIndices(vtkPolyData* output,
  std::vector<pcl::PointIndices> clusterIndices)
{
  vtkSmartPointer<vtkUnsignedIntArray> objectArray = vtkSmartPointer<vtkUnsignedIntArray>::New();
  objectArray->Allocate(output->GetNumberOfPoints());
  objectArray->SetName("clusterIndex");
  objectArray->SetNumberOfTuples(output->GetNumberOfPoints());
  objectArray->Fill(0);
  output->GetPointData()->AddArray(objectArray);
  output->GetPointData()->SetActiveScalars("clusterIndex");

  vtkSMPTools::For(0,
    clusterIndices.size(),
    [&](vtkIdType begin, vtkIdType end)
    {
      for (vtkIdType clusterIdx = begin; clusterIdx < end; clusterIdx++)
      {
        for (auto ptIdx : clusterIndices[clusterIdx].indices)
        {
          objectArray->SetValue(ptIdx, clusterIdx + 1);
        }
      }
    });
}
