/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLSampleConsensusUtils.h

  Copyright (c) Kitware Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLSampleConsensusUtils_h
#define vtkPCLSampleConsensusUtils_h

#include <vtkObject.h>

#include <pcl/common/common.h>
#include <pcl/point_types.h>

#include "vtkPCLSampleConsensusModule.h" // For export macro

class vtkPolyData;

/**
 * @brief Collection of static convenient functions for PCL sample consensus wrapped in VTK.
 */
class VTKPCLSAMPLECONSENSUS_EXPORT vtkPCLSampleConsensusUtils : public vtkObject
{
public:
  static vtkPCLSampleConsensusUtils* New();

  vtkTypeMacro(vtkPCLSampleConsensusUtils, vtkObject);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  /**
   * @brief Create a VTK Plane source from a pcl point cloud using PCA.
   */
  static void CreateVTKPlaneFromPCL(const pcl::PointCloud<pcl::PointXYZ>& cloud,
    const std::vector<int>& indices,
    vtkPolyData* output);

  /**
   * @brief Create a VTK Cylinder source from a pcl point cloud cloud and coeff.
   */
  static void CreateVTKCylinderFromPCL(const pcl::PointCloud<pcl::PointXYZ>& cloud,
    const std::vector<int>& indices,
    Eigen::Vector3d pointOnAxis,
    Eigen::Vector3d axisDirection,
    double radius,
    vtkPolyData* output);

protected:
  vtkPCLSampleConsensusUtils() = default;
  ~vtkPCLSampleConsensusUtils() = default;

private:
  vtkPCLSampleConsensusUtils(const vtkPCLSampleConsensusUtils&);
  void operator=(const vtkPCLSampleConsensusUtils&);
};

#endif // vtkPCLSampleConsensusUtils_h
