/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLVoxelGrid.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See LICENSE or http://www.apache.org/licenses/LICENSE-2.0 for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLVoxelGrid_h
#define vtkPCLVoxelGrid_h

// VTK includes
#include <vtkPolyDataAlgorithm.h>

// PCL includes
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>

#include "vtkPCLFiltersModule.h" // for export macro

/**
 * @brief The vtkPCLVoxelGrid class is a filter that downsamples a point cloud by applying a voxel
 * grid filter. The LeafSize parameter is used to set the size of the voxels. The voxels are cubic.
 * This filter wraps the UniformSampling class from the PCL library.
 */
class VTKPCLFILTERS_EXPORT vtkPCLVoxelGrid : public vtkPolyDataAlgorithm
{
public:
  static vtkPCLVoxelGrid* New();
  vtkTypeMacro(vtkPCLVoxelGrid, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  using Point = pcl::PointXYZ;

  vtkGetMacro(LeafSize, double);
  vtkSetMacro(LeafSize, double);

protected:
  vtkPCLVoxelGrid() = default;
  ~vtkPCLVoxelGrid() = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

private:
  vtkPCLVoxelGrid(const vtkPCLVoxelGrid&);
  void operator=(const vtkPCLVoxelGrid&);

  //! Leaf size of the voxel grid in the same unit as the points
  //! It corresponds to one voxel width and so, to the resolution of the output pointcloud
  double LeafSize = 0.1;
};

#endif // vtkPCLVoxelGrid_h
