/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLNormalSpaceSampling.h

  Copyright (c) Kitware Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLNormalSpaceSampling_h
#define vtkPCLNormalSpaceSampling_h

// vtk includes
#include <vtkPolyDataAlgorithm.h>

// pcl includes
#include <pcl/point_cloud.h>
#include <pcl/point_types.h>

#include "vtkPCLFiltersModule.h" // for export macro

/**
 * @brief The vtkPCLNormalSpaceSampling class is a filter that downsamples a point cloud  in the
 * space of normal directions computed at every point.
 */
class VTKPCLFILTERS_EXPORT vtkPCLNormalSpaceSampling : public vtkPolyDataAlgorithm
{
public:
  static vtkPCLNormalSpaceSampling* New();
  vtkTypeMacro(vtkPCLNormalSpaceSampling, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  using Point = pcl::PointXYZ;

  vtkGetMacro(Sample, unsigned int);
  vtkSetMacro(Sample, unsigned int);

  vtkGetMacro(Seed, unsigned int);
  vtkSetMacro(Seed, unsigned int);

  vtkGetVector3Macro(Bins, unsigned int);
  vtkSetVector3Macro(Bins, unsigned int);

  vtkGetMacro(Radius, double);
  vtkSetMacro(Radius, double);

protected:
  vtkPCLNormalSpaceSampling() = default;
  ~vtkPCLNormalSpaceSampling() = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

private:
  vtkPCLNormalSpaceSampling(const vtkPCLNormalSpaceSampling&);
  void operator=(const vtkPCLNormalSpaceSampling&);

  //! Number of points to sample
  unsigned int Sample = 10000;

  //! Seed of random function
  unsigned int Seed = 0;

  //! Number of bins in each direction
  unsigned int Bins[3] = { 10, 10, 10 };

  //! Radius of the sphere in which the samples are drawn for normal estimation
  double Radius = 0.5;
};

#endif // vtkPCLNormalSpaceSampling_h
