/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLFiltersUtils.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See LICENSE or http://www.apache.org/licenses/LICENSE-2.0 for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkPCLFiltersUtils_h
#define vtkPCLFiltersUtils_h

// VTK includes
#include <vtkPolyDataAlgorithm.h>

#include "vtkPCLFiltersModule.h" // for export macro

/**
 * @brief The vtkPCLFiltersUtils class provides convenient functions for PCL filters wrapped in VTK.
 */
class VTKPCLFILTERS_EXPORT vtkPCLFiltersUtils : public vtkObject
{
public:
  static vtkPCLFiltersUtils* New();
  vtkTypeMacro(vtkPCLFiltersUtils, vtkObject);

  /**
   * @brief RemoveIndices removes the points with the given indices from the
   * input.
   */
  static vtkSmartPointer<vtkPolyData> RemoveIndices(vtkPolyData* input,
    const std::vector<int>* removedIndices);

protected:
  vtkPCLFiltersUtils() = default;
  ~vtkPCLFiltersUtils() = default;

private:
  vtkPCLFiltersUtils(const vtkPCLFiltersUtils&);
  void operator=(const vtkPCLFiltersUtils&);
};

#endif // vtkPCLFiltersUtils_h
