/*=========================================================================

  Program:   PCL Plugin
  Module:    vtkPCLUtils.cxx

  Copyright (c) Kitware Inc.
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkPCLUtils.h"

#include <vtkObjectFactory.h> // for vtkStandardNewMacro

#include <pcl/common/common.h>
#include <pcl/common/io.h>
#include <pcl/features/normal_3d.h>

//----------------------------------------------------------------------------
// Implementation of the New function
vtkStandardNewMacro(vtkPCLUtils);

//-----------------------------------------------------------------------------
void vtkPCLUtils::PrintSelf(ostream& os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}

// ------------------------------------------------------------------------------
pcl::PointCloud<pcl::PointNormal>::Ptr vtkPCLUtils::EstimateAndMergePCLNormals(
  pcl::PointCloud<pcl::PointXYZ>::Ptr inputCloud,
  double searchRadius)
{
  pcl::PointCloud<pcl::Normal>::Ptr normals(new pcl::PointCloud<pcl::Normal>);
  pcl::PointCloud<pcl::PointNormal>::Ptr pointCloudNormal(new pcl::PointCloud<pcl::PointNormal>);

  vtkPCLUtils::EstimatePCLNormals<pcl::PointXYZ>(inputCloud, searchRadius, normals);

  pcl::concatenateFields(*inputCloud, *normals, *pointCloudNormal);
  return pointCloudNormal;
}
