# Introduction

This plugin aims to bring some of functionality of the [Point Cloud Library (PCL)](http://www.pointclouds.org/)
to [ParaView](https://www.paraview.org/).
It includes filters and tools that directly uses PCL algorithms without modification,
as well as higher-level filters that combine PCL tools to perform specific tasks.

# Installation

PCL plugin packages are available to download on the [release page](https://gitlab.kitware.com/LidarView/plugins/pcl-plugin/-/releases).

## How to build

Dependencies are listed in the table below along with the version used during development and testing.
Minimum required versions have not been all determined yet.

| Dependency | Tested Version | Minimum Version |
|:----------:|:--------------:|:---------------:|
|  ParaView  |     5.13.0     |     5.12.0      |
|    PCL     |      1.14      |      1.11       |

The PCL plugin can be installed using the standard CMake procedure:

  - Create a build folder
  - Launch CMake with this repository as source folder
  - Configure the project. It will need PCL and ParaView.

# Available filters

Here is a comprehensive list of the PCL functionalities exposed by the **PCL Plugin** in ParaView.

## Sample Consensus - Shape Fitting

The **PCL Fitting Model** filter fits a model using a chosen sample consensus algorithm. It can fit multiple shapes iteratively, starting with the most prominent shape and continuing until the requested number is reached. It supports various model types, including:
- Planes (with optional normal vector constraints or using surface normals)
- Spheres
- Cylinders
- Lines (with optional direction constraints)
- Circles (2D and 3D)
- Cones

The filter supports multiple sample consensus algorithms, including RANSAC-like variants, though only RANSAC has been extensively tested.

It offers options to retain all points, only inliers, or only outliers. For closed shapes (cylinders and spheres), the filter can also retain points that are either inside or outside the fitted shape. Additionally, it can project points onto inliers.

Additional filters have been implemented using the fitting model:
- **PCL Plane Alignment**: Fits a plane to a point cloud using the RANSAC algorithm and aligns the detected plane (floor) to the XY plane. For example, this could be combined with a clip filter to remove the floor.
- **PCL Wall Fitting**: Fits a set of planes to a point cloud, considering the orthogonality and parallelism of the floor and walls. The orientation of the floor may be given to help determine the planes

## Segmentation

- **PCL Euclidean Cluster Extraction**: This algorithm segments a point cloud into clusters based on spatial proximity. It constructs a kd-tree for efficient nearest neighbor searches and groups points within a specified Euclidean distance.

- **PCL Region Growing**: This filter segments a point cloud based on smoothness constraints. Starting from seed points, it expands regions by merging neighboring points with similar surfaces. The segmentation can be based on normals or color.

![region_growing_rgb](./documentation/region_growing_rgb.png)
An example of the **PCL Region Growing RGB** algorithm applied to an aggregated point cloud from a `VLP-16`, processed using [Kitware SLAM](https://gitlab.kitware.com/keu-computervision/slam) and colorized with [LidarView](https://gitlab.kitware.com/LidarView/lidarview).

## Meshing

- **PCL Greedy Projection Triangulation**: Incrementally constructs a triangle mesh by connecting points to their nearest neighbors. It is useful for reconstructing surfaces from unstructured point clouds, though the resulting mesh may not be watertight.

- **Concave Hull**: Generates a concave hull mesh using an alpha shapes implementation based on [Qhull](http://www.qhull.org/). The alpha value parameter controls the level of concavity in the resulting shape.

- **Convex Hull**: Uses [Qhull](http://www.qhull.org/) library to computes the smallest convex shape that encloses a set of points, useful for shape approximation or collision detection.

![meshing_comparison](./documentation/meshing_comparison.png)

- **PCL Marching Cubes**: Generates surface meshes from volumetric data, such as voxel grids or implicit functions. It is best suited for structured volumetric data but can also be applied to dense point clouds after converting them into a volumetric representation (voxel grid).

- **PCL Poisson**: Creates a surface mesh from a point cloud by solving a Poisson equation that captures the gradient of the surface’s implicit function, using the point cloud's normals for guidance.

## Point Cloud Cleaning

- **PCL Voxel Grid**: Downsample a point cloud by averaging points within a fixed-size 3D grid.
- **PCL Outlier Removal**: Filters out noise points using methods such as:
  * **Statistical Outlier Removal (SOR)**: Removes points that statistically deviate from their neighbors.
  * **Radius Outlier Removal (ROR)**: Removes points based on a distance threshold.
- **PCL Normal Space Sampling**: Ensures a uniform distribution of points in the normal space.

# License

The source code for PCL Plugin is made available under the Apache 2.0 license.

See [LICENSE](./LICENSE).
