#!/bin/sh

set -e

readonly version="1.3.1"
readonly tarball="zlib-$version.tar.gz"
readonly sha256sum="9a93b2b7dfdac77ceba5a558a580e74667dd6fede4585b91eefb60f03b72df23"

readonly zlib_root="$HOME/zlib"
readonly zlib_src="$zlib_root/src"
readonly zlib_build_root="$zlib_root/build"

mkdir -p "$zlib_root"
cd "$zlib_root"

echo "$sha256sum  $tarball" > zlib.sha256sum
curl -OL https://github.com/madler/zlib/releases/download/v$version/$tarball
sha256sum --check zlib.sha256sum
mkdir -p "$zlib_src"
tar -xf "$tarball" -C "$zlib_src" --strip-components 1 --no-same-owner

zlib_build () {
    local prefix="$1"
    shift

    cmake -GNinja \
        -S "$zlib_src" \
        -B "$zlib_build_root" \
        -DCMAKE_BUILD_TYPE=Release \
        "-DCMAKE_INSTALL_PREFIX=$prefix" \
        "$@"
    cmake --build "$zlib_build_root" --target install
}

zlib_build /usr

rm -rf "$zlib_root"
