#!/bin/sh

set -e

readonly version="8.0.2"
readonly tarball="qhull-2020-src-8.0.2.tgz"
readonly sha256sum="b5c2d7eb833278881b952c8a52d20179eab87766b00b865000469a45c1838b7e"

readonly qhull_root="$HOME/qhull"
readonly qhull_src="$qhull_root/src"
readonly qhull_build_root="$qhull_root/build"

mkdir -p "$qhull_root"
cd "$qhull_root"

echo "$sha256sum  $tarball" > qhull.sha256sum
curl -OL http://www.qhull.org/download/qhull-2020-src-8.0.2.tgz
sha256sum --check qhull.sha256sum
mkdir -p "$qhull_src"
tar -xf "$tarball" -C "$qhull_src" --strip-components 1 --no-same-owner

qhull_build () {
    local prefix="$1"
    shift

    cmake -GNinja \
        -S "$qhull_src" \
        -B "$qhull_build_root" \
        -DCMAKE_BUILD_TYPE=Release \
        -DBUILD_SHARED_LIBS=OFF \
        "-DCMAKE_INSTALL_PREFIX=$prefix" \
        -DCMAKE_POLICY_VERSION_MINIMUM=3.5 \
        "$@"
    cmake --build "$qhull_build_root" --target install
}

qhull_build /usr

rm -rf "$qhull_root"
