#!/bin/sh

set -e

readonly version="1.15.0"
readonly tarball="source.tar.gz"
readonly sha256sum="fb79d085b08b8335f43ee4cacf4daa2624bb2c411e9243efa6a92c077273840a"

readonly pcl_root="$HOME/pcl"
readonly pcl_src="$pcl_root/src"
readonly pcl_build_root="$pcl_root/build"

mkdir -p "$pcl_root"
cd "$pcl_root"

echo "$sha256sum  $tarball" > pcl.sha256sum
curl -OL https://github.com/PointCloudLibrary/pcl/releases/download/pcl-$version/$tarball
sha256sum --check pcl.sha256sum
mkdir -p "$pcl_src"
tar -xf "$tarball" -C "$pcl_src" --strip-components 1 --no-same-owner

pcl_build () {
    local prefix="$1"
    shift

    # Missing libatomic in image
    cmake -GNinja \
        -S "$pcl_src" \
        -B "$pcl_build_root" \
        -DCMAKE_BUILD_TYPE=Release \
        -DBoost_USE_STATIC_LIBS=ON \
        -DBoost_DIR="/usr/lib/cmake/Boost-1.86.0/" \
        -DPCL_QHULL_REQUIRED_TYPE="STATIC" \
        -DQhull_DIR:PATH="/usr/lib/cmake/Qhull/" \
        -DPCL_SHARED_LIBS=OFF \
        -DLIBATOMIC_NOT_NEEDED=ON \
        -DWITH_CUDA=OFF \
        -DBUILD_io:BOOL=OFF \
        -DBUILD_global_tests:BOOL=OFF \
        -DBUILD_stereo:BOOL=OFF \
        -DBUILD_tracking:BOOL=OFF \
        -DBUILD_keypoints:BOOL=OFF \
        -DBUILD_outofcore:BOOL=OFF \
        -DBUILD_people:BOOL=OFF \
        -DBUILD_CUDA:BOOL=OFF \
        -DBUILD_GPU:BOOL=OFF \
        -DBUILD_simulation:BOOL=OFF \
        -DBUILD_visualization:BOOL=OFF \
        -DBUILD_examples:BOOL=OFF \
        -DBUILD_tools:BOOL=OFF \
        -DBUILD_apps:BOOL=OFF \
        -DBUILD_recognition:BOOL=OFF \
        -DBUILD_benchmarks:BOOL=OFF \
        -DWITH_PNG:BOOL=OFF \
        -DWITH_OPENNI:BOOL=OFF \
        -DWITH_OPENNI2:BOOL=OFF \
        -DWITH_QT:BOOL=OFF \
        -DWITH_LIBUSB:BOOL=OFF \
        -DWITH_PCAP:BOOL=OFF \
        -DWITH_CUDA:BOOL=OFF \
        -DWITH_OPENGL:BOOL=OFF \
        "-DCMAKE_INSTALL_PREFIX=$prefix" \
        "$@"
    cmake --build "$pcl_build_root" --target install
}

pcl_build /usr

rm -rf "$pcl_root"
