#!/bin/sh

set -e

readonly version="1.9.4"
readonly tarball="lz4-$version.tar.gz"

readonly lz4_root="$HOME/lz4"
readonly lz4_src="$lz4_root/src"
readonly lz4_build_root="$lz4_root/build"

mkdir -p "$lz4_root"
cd "$lz4_root"

curl -OL https://github.com/lz4/lz4/releases/download/v$version/$tarball.sha256
curl -OL https://github.com/lz4/lz4/releases/download/v$version/$tarball
sha256sum --check $tarball.sha256
mkdir -p "$lz4_src"
tar -xf "$tarball" -C "$lz4_src" --strip-components 1 --no-same-owner

lz4_build () {
    local prefix="$1"
    shift

    cmake -GNinja \
        -S "$lz4_src/build/cmake" \
        -B "$lz4_build_root" \
        -DCMAKE_BUILD_TYPE=Release \
        "-DCMAKE_INSTALL_PREFIX=$prefix" \
        -DCMAKE_POLICY_VERSION_MINIMUM=3.5 \
        "$@"
    cmake --build "$lz4_build_root" --target install
}

lz4_build /usr

rm -rf "$lz4_root"
