#!/bin/sh

set -e

readonly version="1.9.2"
readonly tarball="$version.tar.gz"
readonly sha256sum="e26829bb0017f317d9cc45ab83ddcb8b16d75ada1ae07157006c1e7d601c8824"

readonly flann_root="$HOME/flann"
readonly flann_src="$flann_root/src"
readonly flann_build_root="$flann_root/build"
readonly script_dir="$(dirname $(realpath $0))"
readonly patch_root="$script_dir/patches"

mkdir -p "$flann_root"
cd "$flann_root"

echo "$sha256sum  $tarball" > flann.sha256sum
curl -OL https://github.com/flann-lib/flann/archive/refs/tags/$tarball
sha256sum --check flann.sha256sum
mkdir -p "$flann_src"
tar -xf "$tarball" -C "$flann_src" --strip-components 1 --no-same-owner

git apply --directory=src/ $patch_root/flann-remove-pkgconfig-deps.patch
git apply --directory=src/ $patch_root/flann-rng-deterministic-thread-safe.patch

flann_build () {
    local prefix="$1"
    shift

    cmake -GNinja \
        -S "$flann_src" \
        -B "$flann_build_root" \
        -DBUILD_EXAMPLES:BOOL=OFF \
        -DBUILD_SHARED_LIBS=OFF \
        -DCMAKE_BUILD_TYPE=Release \
        "-DCMAKE_INSTALL_PREFIX=$prefix" \
        -DCMAKE_POLICY_VERSION_MINIMUM=3.5 \
        -DBUILD_MATLAB_BINDINGS=OFF \
        -DBUILD_PYTHON_BINDINGS=OFF \
        -DBUILD_C_BINDINGS=OFF \
        "$@"
    cmake --build "$flann_build_root" --target install
}

flann_build /usr

rm -rf "$flann_root"
