#!/bin/sh

set -e

readonly version="3.4.0"
readonly tarball="eigen-$version.tar.gz"
readonly sha256sum="8586084f71f9bde545ee7fa6d00288b264a2b7ac3607b974e54d13e7162c1c72"

readonly eigen_root="$HOME/eigen"
readonly eigen_src="$eigen_root/src"
readonly eigen_build_root="$eigen_root/build"

mkdir -p "$eigen_root"
cd "$eigen_root"

echo "$sha256sum  $tarball" > eigen.sha256sum
curl -OL https://gitlab.com/libeigen/eigen/-/archive/$version/eigen-$version.tar.gz
sha256sum --check eigen.sha256sum
mkdir -p "$eigen_src"
tar -xf "$tarball" -C "$eigen_src" --strip-components 1 --no-same-owner

eigen_build () {
    local prefix="$1"
    shift

    cmake -GNinja \
        -S "$eigen_src" \
        -B "$eigen_build_root" \
        -DCMAKE_BUILD_TYPE=Release \
        "-DCMAKE_INSTALL_PREFIX=$prefix" \
        "$@"
    cmake --build "$eigen_build_root" --target install
}

eigen_build /usr

rm -rf "$eigen_root"
