if (WIN32)
  message(${LVSB_DIR})
  message(${DESTINATION_DIR})
  if (NOT DEFINED LVSB_DIR)
    message(FATAL_ERROR "Missing lvsb install directory.")
  endif()

  if (NOT DEFINED DESTINATION_DIR)
    message(FATAL_ERROR "Missing destination directory.")
  endif()

  file(GLOB pcl_dlls "${LVSB_DIR}/install/bin/pcl*.dll")
  file(GLOB qhull_dlls "${LVSB_DIR}/install/bin/qhull*.dll")
  file(GLOB flann_dlls "${LVSB_DIR}/install/bin/flann*.dll")
  file(GLOB boost_dlls "${LVSB_DIR}/install/bin/boost*.dll")
  file(GLOB lz4_dlls "${LVSB_DIR}/install/bin/lz4*.dll")
  file(GLOB zlib_dlls "${LVSB_DIR}/install/bin/zlib*.dll")

  file(COPY
    ${pcl_dlls}
    ${qhull_dlls}
    ${flann_dlls}
    ${boost_dlls}
    ${lz4_dlls}
    ${zlib_dlls}
    DESTINATION ${DESTINATION_DIR}
  )

endif ()