#!/bin/sh

set -e

readonly version="1.86.0"
readonly tarball="boost-$version-cmake.tar.gz"

readonly boost_root="$HOME/boost"
readonly boost_src="$boost_root/src"
readonly boost_build_root="$boost_root/build"

mkdir -p "$boost_root"
cd "$boost_root"

curl -OL https://github.com/boostorg/boost/releases/download/boost-$version/$tarball.txt
curl -OL https://github.com/boostorg/boost/releases/download/boost-$version/$tarball
sha256sum --check $tarball.txt
mkdir -p "$boost_src"
tar -xf "$tarball" -C "$boost_src" --strip-components 1 --no-same-owner

boost_build () {
    local prefix="$1"
    shift

    cmake -GNinja \
        -S "$boost_src" \
        -B "$boost_build_root" \
        -DCMAKE_BUILD_TYPE=Release \
        -DCMAKE_INSTALL_LIBDIR:STRING=lib \
        "-DCMAKE_INSTALL_PREFIX=$prefix" \
        "$@"
    cmake --build "$boost_build_root" --target install
}

boost_build /usr

rm -rf "$boost_root"
