#!/usr/bin/env bash

set -e
set -x
shopt -s dotglob

readonly name="livoxsdk2"
readonly ownership="Livox SDK2 Upstream <kwrobot@kitware.com>"
readonly subtree="LivoxSDK2/vtk$name"
readonly repo="https://gitlab.kitware.com/LidarView/third-party/livox-sdk2"
readonly tag="for/lidarview-20240221-1.2.5"
readonly paths="
include/livox_lidar_def.h
sdk_core/comm/define.h

LICENSE.txt

CMakeLists.vtk.txt
README.md
README.kitware.md
"

extract_source () {
    git_archive
    pushd "$extractdir/$name-reduced"

    mv -v CMakeLists.vtk.txt CMakeLists.txt
    popd
}

. "${BASH_SOURCE%/*}/../Utilities/update-common.sh"
