#ifndef VTKExemplePacketInterpreter_h
#define VTKExemplePacketInterpreter_h

#include <vtkLidarPacketInterpreter.h>

#include <vtkDoubleArray.h>
#include <vtkTypeUInt64Array.h>
#include <vtkUnsignedIntArray.h>

#include <memory>

class VTK_EXPORT vtkExemplePacketInterpreter : public vtkLidarPacketInterpreter
{
public:
  static vtkExemplePacketInterpreter* New();
  vtkTypeMacro(vtkExemplePacketInterpreter, vtkLidarPacketInterpreter)
  //void PrintSelf(ostream& vtkNotUsed(os), vtkIndent vtkNotUsed(indent)) override;

  vtkSmartPointer<vtkPolyData> CreateNewEmptyFrame(vtkIdType numberOfPoints,
    vtkIdType prereservedNumberOfPoints = 60000) override;

  void LoadCalibration(const std::string& filename) override;

  bool PreProcessPacket(unsigned char const * data, unsigned int dataLength,
                        fpos_t filePosition = fpos_t(), double packetNetworkTime = 0,
                        std::vector<FrameInformation>* frameCatalog = nullptr) override;

  bool IsLidarPacket(unsigned char const * data, unsigned int dataLength) override;

  void ProcessPacket(unsigned char const * data, unsigned int dataLength) override;

  std::string GetSensorInformation(bool shortVersion = false) override;

protected:
  template<typename T>
  vtkSmartPointer<T> CreateDataArray(bool isAdvanced, const char* name, vtkIdType np, vtkIdType prereserved_np, vtkPolyData* pd);

  vtkExemplePacketInterpreter();
  ~vtkExemplePacketInterpreter();

private:
  vtkExemplePacketInterpreter(const vtkExemplePacketInterpreter&) = delete;
  void operator=(const vtkExemplePacketInterpreter&) = delete;

};

#endif // VTKExemplePacketInterpreter_h
