set(paraview_binary_dir)
if (TARGET paraview)
  set(paraview_binary_dir "<BINARY_DIR>")
  _ep_replace_location_tags(paraview paraview_binary_dir)
endif ()

superbuild_add_project(slam
  DEPENDS paraview eigen ceres pcl nanoflann
  DEPENDS_OPTIONAL g2o openmp opencv gtsam teaserpp qt5 python3
  DEBUGGABLE
  LICENSE_FILES
    LICENSE.txt

  CMAKE_ARGS
    -DSLAM_PARAVIEW_PLUGIN:BOOL=True
    -DBUILD_SHARED_LIBS:BOOL=${BUILD_SHARED_LIBS}
    -DENABLE_OpenCV=${ENABLE_opencv}
    -DENABLE_g2o=${ENABLE_g2o}
    -DENABLE_GTSAM=${ENABLE_gtsam}
    -DENABLE_teaserpp=${ENABLE_teaserpp}
    -DCMAKE_INSTALL_LIBDIR:PATH=lib
)

if (WIN32)
  superbuild_append_flags(cxx_flags "/MD" PROJECT_ONLY)
endif()
