if (paraview_enabled)
  set(vtk_cmake_dir "<INSTALL_DIR>/lib/cmake/paraview-${paraview_version}/vtk")
endif ()

superbuild_add_project(pcl
  DEPENDS flann eigen boost png zlib qhull
  DEPENDS_OPTIONAL pcap paraview
  LICENSE_FILES
    LICENSE.txt

  CMAKE_ARGS
  -DCMAKE_CXX_STANDARD=14
  -DCMAKE_CXX_STANDARD_REQUIRED:BOOL=ON
  -DCMAKE_INSTALL_LIBDIR:STRING=lib
  -DCMAKE_INSTALL_NAME_DIR:PATH=<INSTALL_DIR>/lib
  -DCMAKE_INSTALL_RPATH:STRING=<INSTALL_DIR>/lib
  -DPCL_ONLY_CORE_POINT_TYPES:BOOL=ON
  -DBoost_USE_MULTITHREAD:BOOL=ON
  -DPCL_BUILD_WITH_BOOST_DYNAMIC_LINKING_WIN32:BOOL=ON
  -DBOOST_LIBRARYDIR:PATH=<INSTALL_DIR>/lib #The following lines are mandatory to prevent a bug where PCL links against SYSTEM boost
  -DBoost_LIBRARY_DIR_DEBUG:PATH=<INSTALL_DIR>/lib
  -DBoost_LIBRARY_DIR_RELEASE:PATH=<INSTALL_DIR>/lib
  -DQhull_DIR:PATH=<INSTALL_DIR>/lib/cmake/Qhull
  -DPCL_BUILD_WITH_QHULL_DYNAMIC_LINKING_WIN32:BOOL=ON
  -DVTK_DIR:PATH=${vtk_cmake_dir}
  -DBUILD_common:BOOL=ON
  -DBUILD_geometry:BOOL=ON
  -DBUILD_kdtree:BOOL=ON
  -DBUILD_search:BOOL=ON
  -DBUILD_sample_consensus:BOOL=ON
  -DBUILD_io:BOOL=ON
  -DBUILD_octree:BOOL=ON
  -DBUILD_features:BOOL=ON
  -DBUILD_filters:BOOL=ON
  -DBUILD_2d:BOOL=ON
  -DBUILD_global_tests:BOOL=OFF
  -DBUILD_stereo:BOOL=OFF
  -DBUILD_surface:BOOL=OFF
  -DBUILD_tracking:BOOL=OFF
  -DBUILD_ml:BOOL=OFF
  -DBUILD_keypoints:BOOL=OFF
  -DBUILD_outofcore:BOOL=OFF
  -DBUILD_people:BOOL=OFF
  -DBUILD_CUDA:BOOL=OFF
  -DBUILD_GPU:BOOL=OFF
  -DBUILD_registration:BOOL=OFF
  -DBUILD_segmentation:BOOL=OFF
  -DBUILD_simulation:BOOL=OFF
  -DBUILD_visualization:BOOL=OFF
  -DBUILD_examples:BOOL=OFF
  -DBUILD_tools:BOOL=OFF
  -DBUILD_apps:BOOL=OFF
  -DBUILD_OPENNI:BOOL=OFF
  -DBUILD_recognition:BOOL=OFF
  -DBUILD_benchmarks:BOOL=OFF
  -DWITH_PNG:BOOL=ON
  -DWITH_OPENNI:BOOL=OFF
  -DWITH_OPENNI2:BOOL=OFF
  -DWITH_QT:BOOL=OFF
  -DWITH_VTK:BOOL=${paraview_enabled}
  -DWITH_LIBUSB:BOOL=OFF
  -DWITH_PCAP:BOOL=OFF
  -DWITH_FZAPI:BOOL=OFF
  -DWITH_PXCAPI:BOOL=OFF
  -DWITH_MPI:BOOL=OFF
  -DWITH_CUDA:BOOL=OFF
  -DWITH_DOCS:BOOL=OFF
)
