include(paraview-version)

set(paraview_plugin_path "lib/paraview-${paraview_version}/plugins")
set(lidarview_plugin_path "lib/lidarview/plugins")
set(slam_plugin_path "lib/slam/plugins")

# Trigger lidarview common bundling
include(lidarview.bundle.common)

# Trigger common lidarview based app bundling
include(lidarviewapp.bundle)

# LidarView-Apple Specifics

# Sensor calibration files
file(GLOB shared_files "${share_path}/*.csv")
install(FILES ${shared_files}
        DESTINATION "${lidarview_appname}/Contents/Resources"
        COMPONENT superbuild)
unset(shared_files)

file(GLOB shared_files "${share_path}/*.xml")
install(FILES ${shared_files}
        DESTINATION "${lidarview_appname}/Contents/Resources"
        COMPONENT superbuild)
unset(shared_files)
