# change osx path from libboost_* to @rpath/libboost_*
file(GLOB boost_libs LIST_DIRECTORIES false "${install_location}/*/*/Contents/Libraries/libboost*.dylib")
file(GLOB app_names LIST_DIRECTORIES false "${install_location}/bin/*/Contents/MacOS/*")
file(GLOB test_names LIST_DIRECTORIES false "${install_location}/bin/Test*")
foreach (boost_lib IN LISTS boost_libs)
  get_filename_component(libboost_name "${boost_lib}" NAME)

  # apply change for the osx app in "${install_location}/bin"
  foreach (app_name IN LISTS app_names)
    execute_process(
      COMMAND install_name_tool
      -change "${libboost_name}" "@rpath/${libboost_name}"
      "${app_name}")
  endforeach ()
  
  # apply changes for all tests installed in "${install_location}/bin"
  foreach (test_name IN LISTS test_names)
    execute_process(
      COMMAND install_name_tool
      -change "${libboost_name}" "@rpath/${libboost_name}"
      "${test_name}")
  endforeach ()
endforeach ()
