set(pv_cmake_options "")
find_package(Protobuf)
if (Protobuf_FOUND)
  message(MESSAGE "Found a system-wide Protobuf library, tell VTK to use it to avoid runtime version mismatch")
  set(VTK_USE_SYSTEM_PROTOBUF ON CACHE BOOL "Tell paraview to use the system-wide Protobuf that CMake found, to avoid runtime version mismatch.")
  list(APPEND pv_cmake_options "-DVTK_USE_SYSTEM_PROTOBUF:BOOL=${VTK_USE_SYSTEM_PROTOBUF}" )
endif()
superbuild_add_project(paraview
  DEPENDS qt5 python python3 pythonqt
  DEFAULT_ON
  DEBUGGABLE
  CMAKE_ARGS
    -DCMAKE_CXX_STANDARD=11
    -DPARAVIEW_ENABLE_EMBEDDED_DOCUMENTATION:BOOL=ON
    -DBUILD_SHARED_LIBS:BOOL=ON
    -DBUILD_TESTING:BOOL=OFF
    -DPARAVIEW_BUILD_QT_GUI:BOOL=ON
    -DPARAVIEW_ENABLE_PYTHON:BOOL=ON
    -DPARAVIEW_ENABLE_CATALYST:BOOL=OFF
    -DPARAVIEW_ENABLE_VTK_MODULES_AS_NEEDED:BOOL=OFF
    -DPARAVIEW_ENABLE_WEB:BOOL=OFF
    -DPARAVIEW_ENABLE_MATPLOTLIB:BOOL=OFF
    -DPARAVIEW_ENABLE_SPYPLOT_MARKERS:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_AcceleratedAlgorithms:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_AdiosReader:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_AnalyzeNIfTIIO:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_ArrowGlyph:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_Catalyst:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_CDIReader:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_CoProcessingScriptGenerator:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_EyeDomeLighting:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_ForceTime:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_GeodesicMeasurement:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_GMVReader:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_H5PartReader:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_LagrangianParticleTracker:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_MantaView:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_MobileRemoteControl:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_Moments:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_NonOrthogonalSource:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_PacMan:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_PointSprite:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_PointCloudRepresentation:BOOL=ON
    -DPARAVIEW_AUTOLOAD_PLUGIN_PointCloudRepresentation:BOOL=ON
    -DPARAVIEW_BUILD_PLUGIN_EyeDomeLighting:BOOL=ON
    -DPARAVIEW_AUTOLOAD_PLUGIN_EyeDomeLighting:BOOL=ON
    -DPARAVIEW_BUILD_PLUGIN_PrismPlugin:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_pvblot:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_QuadView:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_RGBZView:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_SLACTools:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_SciberQuestToolKit:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_StreamLinesRepresentation:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_StreamingParticles:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_SierraPlotTools:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_SurfaceLIC:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_ThickenLayeredCells:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_UncertaintyRendering:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_VRPlugin:BOOL=OFF
    -DPARAVIEW_BUILD_PLUGIN_VaporPlugin:BOOL=OFF
    -DHDF5_ENABLE_EMBEDDED_LIBINFO:BOOL=OFF
    -DHDF5_ENABLE_DIRECT_VFD:BOOL=OFF
    -DPARAVIEW_CLIENT_RENDER_SERVER_TESTS:BOOL=OFF
    -DPARAVIEW_COLLABORATION_TESTING:BOOL=OFF
    -DVTK_BUILD_QT_DESIGNER_PLUGIN:BOOL=OFF
    -DVTK_QT_VERSION:STRING=${qt_version}
    -DPARAVIEW_QT_VERSION:STRING=${qt_version}
    -DVTK_RENDERING_BACKEND:STRING=OpenGL2
    -DVTK_LEGACY_SILENT:BOOL=ON
    ${pv_cmake_options}

    -DPARAVIEW_BUILD_PLUGIN_PythonQtPlugin:BOOL=ON
    -DPYTHONQT_DIR:PATH=<INSTALL_DIR>
    #-DPYTHONQT_INCLUDE_DIR:PATH=<INSTALL_DIR>/include/PythonQt
    #-DPYTHONQT_LIBRARY:PATH=<INSTALL_DIR>/lib/libPythonQt.so

    -DModule_vtklibproj:BOOL=ON

    # beginning of modules required when opening a .series
    -DModule_vtkIOAMR:BOOL=ON
    -DModule_vtkIOLSDyna:BOOL=ON
    -DModule_vtkIOParallelLSDyna:BOOL=ON
    -DModule_vtkIOTecplotTable:BOOL=ON
    -DModule_vtkIOTRUCHAS:BOOL=ON
    -DModule_vtkIOVPIC:BOOL=ON
    # end of modules required when opening a .series

    # beginning of modules required when making python plugins with numpy array
    -DModule_vtkPVPythonAlgorithm:BOOL=ON
    -DModule_vtkFiltersVerdict:BOOL=ON
    # end of modules required when making python plugins with numpy array

    -DPQWIDGETS_DISABLE_QTWEBKIT:BOOL=ON

    # specify the apple app install prefix. No harm in specifying it for all
    # platforms.
    -DMACOSX_APP_INSTALL_PREFIX:PATH=<INSTALL_DIR>/Applications
)
