superbuild_add_project(pcl
  DEPENDS flann eigen boost png zlib qhull

  CMAKE_ARGS
  -DCMAKE_CXX_STANDARD=14
  -DCMAKE_CXX_STANDARD_REQUIRED:BOOL=ON
  -DPCL_ONLY_CORE_POINT_TYPES:BOOL=ON
  -DBoost_NO_BOOST_CMAKE:BOOL=ON
  -DBoost_USE_MULTITHREAD:BOOL=ON
  -DPCL_BUILD_WITH_BOOST_DYNAMIC_LINKING_WIN32:BOOL=ON
  -DBOOST_LIBRARYDIR:PATH=<INSTALL_DIR>/lib
  -DBoost_LIBRARY_DIR_DEBUG:PATH=<INSTALL_DIR>/lib
  -DBoost_LIBRARY_DIR_RELEASE:PATH=<INSTALL_DIR>/lib
  -DQHULL_LIBRARY:FILEPATH=<INSTALL_DIR>/lib/${CMAKE_STATIC_LIBRARY_PREFIX}qhullstatic${CMAKE_STATIC_LIBRARY_SUFFIX}
  -DQHULL_LIBRARY_DEBUG:FILEPATH=<INSTALL_DIR>/lib/${CMAKE_STATIC_LIBRARY_PREFIX}qhullstatic${CMAKE_STATIC_LIBRARY_SUFFIX}
  -DBUILD_visualization:BOOL=OFF
  -DBUILD_examples:BOOL=OFF
  -DBUILD_tools:BOOL=OFF
  -DBUILD_apps:BOOL=OFF
  -DBUILD_OPENNI:BOOL=OFF
  -DBUILD_recognition:BOOL=OFF
  -DWITH_PNG:BOOL=ON
  -DWITH_OPENNI:BOOL=OFF
  -DWITH_QT:BOOL=OFF
  -DWITH_VTK:BOOL=OFF
  -DWITH_LIBUSB:BOOL=OFF
  -DWITH_PCAP:BOOL=OFF
  -DWITH_FZAPI:BOOL=OFF
  -DWITH_PXCAPI:BOOL=OFF
  -DWITH_MPI:BOOL=OFF
  -DWITH_CUDA:BOOL=OFF
  -DWITH_DOCS:BOOL=OFF
)

superbuild_add_extra_cmake_args(
  -DPCL_DIR:PATH=<INSTALL_DIR>/share/pcl-1.10
)

# If on Windows and using MSVC < 2017, remove constexpr declarations
if (WIN32 AND MSVC AND MSVC_VERSION VERSION_LESS 1910)
  superbuild_apply_patch(pcl msvc2015-compatibility "Remove constexpr declarations for MSVC 2015 support")
endif ()
