# Please use https links whenever possible because some people
# cannot clone using ssh (git://) due to a firewalled network.
# This maintains the links for all sources used by this superbuild.
# Simply update this file to change the revision.
# One can use different revision on different platforms.
# e.g.
# if (UNIX)
#   ..
# else (APPLE)
#   ..
# endif()

superbuild_set_revision(pcap
  URL "https://www.tcpdump.org/release/libpcap-1.10.6.tar.xz"
  URL_MD5 "e46b62dbe89611e03712fe79c5743245")

superbuild_set_revision(npcap
  URL "https://npcap.com/dist/npcap-sdk-1.13.zip"
  URL_MD5 "2067b3975763ddf61d4114d28d9d6c9b")

superbuild_set_revision(tins
  URL     "https://github.com/mfontanini/libtins/archive/refs/tags/v4.5.tar.gz"
  URL_MD5 "a8029f396e4c87bd6d04f48b933d8688")

superbuild_set_revision(ceres
  URL "https://github.com/ceres-solver/ceres-solver/archive/refs/tags/2.2.0.zip"
  URL_MD5 "37bf4a9e668f32fbcfa11999794d0659")

superbuild_set_revision(glog
  URL "https://github.com/google/glog/archive/refs/tags/v0.7.1.zip"
  URL_MD5 "fa30180d4284c454bdd324ad3baf7f5f")

set(lidarview_superbuild_branch_is_for_release 0)
if (lidarview_superbuild_branch_is_for_release)
  set(lv_release_default "DEFAULT")
  set(lv_git_default "")
else ()
  set(lv_release_default "")
  set(lv_git_default "DEFAULT")
endif ()

superbuild_set_selectable_source(lidarview
  # NOTE: When updating this selection, also update the default version in
  # README.md and the LIDARVIEW_VERSION_DEFAULT variable in CMakeLists.txt.
  SELECT 5.2.0 ${lv_release_default}
    GIT_REPOSITORY "https://gitlab.kitware.com/LidarView/lidarview.git"
    GIT_TAG        "v5.2.0"
  SELECT git CUSTOMIZABLE ${lv_git_default}
    GIT_REPOSITORY "https://gitlab.kitware.com/LidarView/lidarview.git"
    GIT_TAG        "master"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-lidarview")

superbuild_set_selectable_source(slam
  SELECT 3.0-lv5.2 ${lv_release_default}
    GIT_REPOSITORY "https://gitlab.kitware.com/keu-computervision/slam.git"
    GIT_TAG        "3db527752fe298ea4498d9bd633d2e5469836762"
  SELECT git CUSTOMIZABLE ${lv_git_default}
    GIT_REPOSITORY "https://gitlab.kitware.com/keu-computervision/slam.git"
    GIT_TAG        "master"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-slam")

superbuild_set_selectable_source(ros2io
  SELECT 1.0 ${lv_release_default}
    URL            "https://gitlab.kitware.com/LidarView/plugins/ros2-io/-/archive/v1.0/ros2-io-v1.0.zip"
    URL_MD5        "7fa854d71268dd3138d79997866a8526"
  SELECT git CUSTOMIZABLE ${lv_git_default}
    GIT_REPOSITORY "https://gitlab.kitware.com/LidarView/plugins/ros2-io.git"
    GIT_TAG        "master"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-ros2io")

superbuild_set_selectable_source(pclplugin
  SELECT 1.1 ${lv_release_default}
    URL            "https://gitlab.kitware.com/LidarView/plugins/pcl-plugin/-/archive/v1.1/pcl-plugin-v1.1.zip"
    URL_MD5        "d260085a5646f52d5da7e0a90132831d"
  SELECT git CUSTOMIZABLE ${lv_git_default}
    GIT_REPOSITORY "https://gitlab.kitware.com/LidarView/plugins/pcl-plugin.git"
    GIT_TAG        "master"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-pclplugin")

superbuild_set_selectable_source(bimprocessing
  SELECT 1.0 ${lv_release_default}
    URL            "https://gitlab.kitware.com/LidarView/plugins/BimProcessing/-/archive/v1.0/BimProcessing-v1.0.zip"
    URL_MD5        "8b02defbaaa65ec76e40c452b56af3ea"
  SELECT git CUSTOMIZABLE ${lv_git_default}
    GIT_REPOSITORY "https://gitlab.kitware.com/LidarView/plugins/BimProcessing.git"
    GIT_TAG        "master"
  SELECT source CUSTOMIZABLE
    SOURCE_DIR "source-bimprocessing")

superbuild_set_revision(fastcdr
  URL "https://github.com/eProsima/Fast-CDR/archive/refs/tags/v2.3.0.zip"
  URL_MD5 "5d307890969400fd4dc7c7b12a7720c0")

superbuild_set_revision(mcap
  URL "https://github.com/foxglove/mcap/archive/refs/tags/releases/cpp/v1.4.1.zip"
  URL_MD5 "e92af6de61124b00571a8094b75aa1c3")

superbuild_set_revision(asio
  URL "https://sourceforge.net/projects/asio/files/asio/1.36.0%20%28Stable%29/asio-1.36.0.zip"
  URL_MD5 "0a3d67167e3a055db6efcadfe7835d59")

superbuild_set_revision(fastdds
  URL "https://github.com/eProsima/Fast-DDS/archive/refs/tags/v3.3.0.zip"
  URL_MD5 "494bf9cd9d2b6b1445d81bc4a13ab5f7")

superbuild_set_revision(foonathan
  URL "https://github.com/eProsima/foonathan_memory_vendor/archive/refs/tags/v1.3.1.zip"
  URL_MD5 "cb45361174e795067150611c2fa0483d")

superbuild_set_revision(tinyxml2
  URL "https://github.com/leethomason/tinyxml2/archive/refs/tags/11.0.0.tar.gz"
  URL_MD5 "e0fbd280045af095b26d2430d38f0c34")

superbuild_set_revision(pcl
  URL "https://github.com/PointCloudLibrary/pcl/archive/refs/tags/pcl-1.15.0.zip"
  URL_MD5 "72c44995745d8cb74efb29e57299615d")

superbuild_set_revision(flann
  URL "https://github.com/flann-lib/flann/archive/refs/tags/1.9.2.zip"
  URL_MD5 "9a1f10c0d890a9595f2f4312436af50f")

superbuild_set_revision(teaserpp
  URL "https://gitlab.kitware.com/LidarView/third-party/teaser-plusplus/-/archive/v3.0-unofficial/teaser-plusplus-v3.0-unofficial.zip"
  URL_MD5 "2a944dbf8b2c2e04f46fc76bb7ad3ddf")

superbuild_set_revision(clipper
  URL "https://github.com/mit-acl/clipper/archive/refs/heads/main.zip"
  URL_MD5 "42db2ac5ebbb780bd4fab01af53a2b6e")

superbuild_set_revision(scs
  URL "https://github.com/cvxgrp/scs/archive/refs/tags/3.2.7.zip"
  URL_MD5 "8956d90700dbe08aef548b6282ce225d")

superbuild_set_revision(opencv
  URL "https://github.com/opencv/opencv/archive/refs/tags/4.11.0.zip"
  URL_MD5 "d2b425c73a45d7b2d4bcbb7ba17d4300")

superbuild_set_revision(opencvcontrib
  URL "https://github.com/opencv/opencv_contrib/archive/refs/tags/4.11.0.tar.gz"
  URL_MD5 "7dd4bc67eb67faff96ce71745a5e3abe")

superbuild_set_revision(nanoflann
  URL "https://github.com/jlblancoc/nanoflann/archive/refs/tags/v1.7.1.zip"
  URL_MD5 "1d0a7821a6ac9906965593f4d85acf8b")

superbuild_set_revision(yaml
  URL "https://github.com/jbeder/yaml-cpp/archive/refs/tags/yaml-cpp-0.7.0.zip"
  URL_MD5 "1e8ca0d6ccf99f3ed9506c1f6937d0ec")

superbuild_set_revision(g2o
  URL "https://github.com/RainerKuemmerle/g2o/archive/refs/tags/20241228_git.zip"
  URL_MD5 "92bb4d2b9107da947567ba5568294128")

superbuild_set_revision(gtsam
  URL "https://github.com/borglab/gtsam/archive/refs/tags/4.2.zip"
  URL_MD5 "e17cfc58af4cc6f1bd639e273523673d")

superbuild_set_revision(pahoc
  URL "https://github.com/eclipse-paho/paho.mqtt.c/archive/refs/tags/v1.3.14.zip"
  URL_MD5 "cc39ad1a0e9ba884a2cf37a38c5e58ef")

superbuild_set_revision(pahocpp
  URL "https://github.com/eclipse-paho/paho.mqtt.cpp/archive/refs/tags/v1.5.0.zip"
  URL_MD5 "a66ee0640e7ec33bd9d885ba1e972630")
