# Install Qt6

Qt6 must be install independently:

 - Using Qt6 [installer](https://www.qt.io/download-qt-installer-oss)

    * Note that only the `Desktop 64-bit` component is needed
    * Installation location:
      - On Unix we recommend a `/opt` installation, and adding this directory to your ld configuration using:
        `sudo echo "/usr/local/lib" >> /etc/ld.so.conf && sudo ldconfig`
      - On Windows we recommend a `C:\` installation

 - If you system's package manager offers Qt6 with version 6.9.0 or higher (e.g Ubuntu22) use:
    `qt6-base-dev qt6-tools-dev qt6-svg-dev qt6-multimedia-dev libqt6core5compat6-dev`

## Test Qt installation

You can test that `Qt6` has been correctly installed with `qmake -v`, which should give you the `Qt` version installed. 

## Configure with installed Qt6 <a name="configure-with-qt"></a>

Add proper parameters to CMake superbuild configuration options:
```
cmake ../<path-to-superbuild-src> -GNinja  -DUSE_SYSTEM_qt=ON -DUSE_SYSTEM_qt6=ON -DQt6_DIR="/path/to/install/location/lib/cmake/Qt6"
```
Depending on your Qt installation `-DQt6_DIR` may not be necessary.

**Always forward slashes, UNIX style, on all platforms**
- e.g If installed in `/opt`: `-DQt6_DIR=/opt/Qt6.9.2/6.9.2/gcc_64/lib/cmake/Qt6`
- e.g If installed in `C:\` : `-DQt6_DIR=C:/Qt/6.9.2/msvc2022_64/lib/cmake/Qt6`
