#!/bin/sh

set -e

apt update

# Install locales
apt-get -y install locales

# Install xvfb for offline graphical testing
apt install -y --no-install-recommends \
    xvfb libxcursor1

# Install extra dependencies for ParaView
apt install -y --no-install-recommends \
    libglvnd-dev bzip2 patch doxygen git git-lfs

# Qt extra depency
DEBIAN_FRONTEND=noninteractive apt install -y --no-install-recommends \
    tzdata libxcb-cursor0 libxcb-xinput-dev

# Qt dependencies
apt install -y --no-install-recommends \
    qt6-base-dev qt6-tools-dev qt6-svg-dev qt6-multimedia-dev

# Development tools
apt install -y --no-install-recommends \
    clang-tools clang-tidy clang-format cmake cmake-curses-gui \
    gcc g++ libgfortran5 ninja-build curl build-essential chrpath
apt install -y --no-install-recommends --reinstall \
    ca-certificates

# Pcap dependencies
apt install -y --no-install-recommends \
    flex byacc

apt clean all
