#!/bin/sh

set -e

# Install python for aqtinstall
dnf install -y --setopt=install_weak_deps=False \
    python3.12 python3.12-pip

readonly venv_root="$HOME/.venv"

python3.12 -m venv "$venv_root"
source "$venv_root/bin/activate"

pip3 install -U pip
pip install aqtinstall
aqt install-qt linux desktop 6.9.0 linux_gcc_64 -m qt5compat qtmultimedia

deactivate
rm -rf "$venv_root"

# Remove unused packages
dnf remove -y \
    python3.12 python3.12-pip
