include(lidarview-version)
include(paraview-version)

set(lidarview_extract_dir "${CMAKE_CURRENT_BINARY_DIR}/lidarview/test-extraction")
if (WIN32)
  set(generator "ZIP")
  set(lidarview_exe "${lidarview_extract_dir}/bin/LidarView.exe")
  set(pvpython_exe "${lidarview_extract_dir}/bin/pvpython.exe") # Testing pvpython for now as lvpython doesn't work correctly
elseif (APPLE)
  set(generator "DragNDrop")
  set(lidarview_appname "LidarView.app")
  set(lidarview_exe "${lidarview_extract_dir}/${lidarview_appname}/Contents/MacOS/LidarView")
  set(pvpython_exe "${lidarview_extract_dir}/${lidarview_appname}/Contents/bin/pvpython") # Testing pvpython for now as lvpython doesn't work correctly
else ()
  set(generator "TGZ")
  set(lidarview_exe "${lidarview_extract_dir}/bin/LidarView")
  set(pvpython_exe "${lidarview_extract_dir}/bin/pvpython") # Testing pvpython for now as lvpython doesn't work correctly
endif ()

set(name_suffix "")
if (lidarview_version_branch)
  set(name_suffix "-${lidarview_version_branch}")
  string(REPLACE "/" "" name_suffix ${name_suffix})
endif ()

set(glob_prefix "LidarView${name_suffix}-${lidarview_version_full}*")
superbuild_add_extract_test("lidarview" "${glob_prefix}" "${generator}" "${lidarview_extract_dir}"
  LABELS "LidarView")

function (lidarview_add_test name exe)
  if (NOT exe)
    return ()
  endif ()

  add_test(
    NAME    "lidarview-${name}"
    COMMAND "${exe}"
            ${ARGN})
  set_tests_properties(lidarview-${name}
    PROPERTIES
      LABELS  "LidarView"
      DEPENDS "extract-lidarview-${generator}")
endfunction ()

function (lidarview_add_ui_test name script)
  lidarview_add_test("${name}" "${lidarview_exe}"
    "--dr"
    "--test-directory=${CMAKE_BINARY_DIR}/Testing/Temporary"
    "--test-script=${CMAKE_CURRENT_LIST_DIR}/xml/${script}.xml"
    ${ARGN}
    "--exit")
endfunction ()

set(python_exception_regex "exception;Traceback")

function (lidarview_add_python_test name script)
  lidarview_add_test("${name}" "${pvpython_exe}"
    "${CMAKE_CURRENT_LIST_DIR}/python/${script}.py")
  # check for exceptions and tracebacks during python execution
  if (TEST "lidarview-${name}")
    set_tests_properties("lidarview-${name}" PROPERTIES
      FAIL_REGULAR_EXPRESSION "${python_exception_regex}"
    )
endif ()
endfunction ()

# Simple test to launch app and test ParaView functionalities.
lidarview_add_ui_test("test-paraviewui" "TestParaviewUI")

# Simple test to launch app and test LidarView functionalities.
lidarview_add_ui_test("test-lidarviewui" "TestLidarviewUI"
  "--data-directory=${CMAKE_CURRENT_LIST_DIR}/data/"
  "--test-baseline=${CMAKE_CURRENT_LIST_DIR}/baselines/Superbuild-TestLidarViewUI.png")

# Simple test to test pvpython/pvbatch.
lidarview_add_python_test("pvpython" "basic_python")

if (numpy_enabled)
  lidarview_add_python_test("import-numpy" "import_numpy")
endif ()

if (hesaisdk_enabled)
  lidarview_add_ui_test("test-lidarviewhesai" "TestLidarviewHesaiSDK"
    "--data-directory=${CMAKE_CURRENT_LIST_DIR}/data/"
    "--test-baseline=${CMAKE_CURRENT_LIST_DIR}/baselines/Superbuild-TestLidarviewHesaiSDK.png")
endif ()

if (slam_enabled)
  lidarview_add_ui_test("test-lidarviewslam" "TestLidarviewSLAM"
    "--data-directory=${CMAKE_CURRENT_LIST_DIR}/data/"
    "--test-baseline=${CMAKE_CURRENT_LIST_DIR}/baselines/Superbuild-TestLidarviewSLAM.png")
endif ()
