#=============================================================================
# Copyright 2020 Kitware, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#=============================================================================

# Install all plugins located in the auto-loaded directory and their dependencies

# Windows : auto-loaded plugins located in bin/plugins
if (WIN32)
  file(GLOB lv_plugins "${superbuild_install_location}/bin/plugins/*.dll")
  foreach (lv_plugin IN LISTS lv_plugins)
    superbuild_windows_install_plugin(
      "${lv_plugin}"
      "bin"
      "bin/plugins"
      SEARCH_DIRECTORIES "${superbuild_install_location}/bin")
  endforeach ()

# MacOS : auto-loaded plugins located in bin/LidarView.app/Contents/MacOS/plugins
elseif (APPLE)
  file(GLOB lv_plugins "${superbuild_install_location}/bin/${SOFTWARE_NAME}.app/Contents/MacOS/plugins/*.dylib")
  foreach (lv_plugin IN LISTS lv_plugins)
    superbuild_apple_install_module(
      "\${CMAKE_INSTALL_PREFIX}"
      "${SOFTWARE_NAME}.app"
      "${lv_plugin}"
      "Contents/MacOS/plugins")
  endforeach ()

# Unix : auto-loaded plugins located in lib/lidarview-version/plugins
elseif (UNIX)
  file(GLOB lv_plugins "${superbuild_install_location}/lib/lidarview-${VV_VERSION}/plugins/*.so*")
  foreach (lv_plugin IN LISTS lv_plugins)
    superbuild_unix_install_plugin(
      "${lv_plugin}"
      "lib"
      "lib/lidarview-${VV_VERSION}/plugins")
  endforeach ()

endif ()
