# Do some of the original configure preset tests as sanity check
if (NOT CMAKE_BINARY_DIR MATCHES "RunCMake/CMakePresetsPackage/GoodOverrideBasic/build/default\$")
    message(SEND_ERROR "Configure preset did not update build directory: ${CMAKE_BINARY_DIR}")
endif ()
if (NOT TEST_CONFIGURE_VAR STREQUAL "override")
    message(SEND_ERROR "Configure preset was not overridden: TEST_CONFIGURE_VAR=${TEST_CONFIGURE_VAR}")
endif ()

set(CPACK_PACKAGE_NAME Good)
set(CPACK_GENERATOR "TGZ;TXZ")

include(CPack)

install(CODE [[
function(print_env name)
  if(DEFINED ENV{${name}})
    file(APPEND $ENV{DESTDIR}${CMAKE_INSTALL_PREFIX}/env.txt "${name}=$ENV{${name}}\n")
  else()
    file(APPEND $ENV{DESTDIR}${CMAKE_INSTALL_PREFIX}/env.txt "${name} not defined\n")
  endif()
endfunction()

file(REMOVE $ENV{DESTDIR}${CMAKE_INSTALL_PREFIX}/env.txt)
print_env(TEST_OVERRIDE_ENV)
print_env(TEST_NEW_ENV)

file(APPEND $ENV{DESTDIR}${CMAKE_INSTALL_PREFIX}/configs.txt "$<CONFIG>\n")
]])
