# Do some of the original configure preset tests as sanity check
if (NOT CMAKE_BINARY_DIR MATCHES "RunCMake/CMakePresetsBuild/GoodOverrideGroups/build/default\$")
    message(SEND_ERROR "Configure preset did not update build directory: ${CMAKE_BINARY_DIR}")
endif ()
if (NOT TEST_CONFIGURE_VAR STREQUAL "override")
    message(SEND_ERROR "Configure preset was not overridden: TEST_CONFIGURE_VAR=${TEST_CONFIGURE_VAR}")
endif ()

# Build preset tests
add_custom_target(original ALL
        COMMENT "target: original"
        COMMAND ${CMAKE_COMMAND} -E false
)
add_custom_target(override ALL
        COMMENT "target: override"
        COMMAND ${CMAKE_COMMAND} -E echo "override"
)
