/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/

#pragma once

#include "LBM.h"
#include <vtkRectilinearGrid.h>
#include <vtkSmartPointer.h>

class LBM_DECL LBMVTK
{
public:
  static bool FromVTR(vtkSmartPointer<vtkRectilinearGrid> vtr, LBM& lbm);
  static bool ReadVTR(std::string const& filename, LBM& lbm);

  static vtkSmartPointer<vtkRectilinearGrid> ToVTR(LBM const& lbm);
  static bool WriteVTR(std::string const& filename, LBM const& lbm);

  // Cell labels used in VTR
  static constexpr char const* SOURCE_LABELS = "Source Labels";
  static constexpr char const* BOUNDARY_LABELS = "Boundary Labels";
  static constexpr char const* PRESSURE = "Pressure";
  static constexpr char const* X_FLOW = "Velocity in X direction";
  static constexpr char const* Y_FLOW = "Velocity in Y direction";
  static constexpr char const* Z_FLOW = "Velocity in Z direction";
  static constexpr char const* TEMPERATURE = "Temperature";
  static constexpr char const* STRESS = "Wall Shear Stress";
  // Expanded Results
  static constexpr char const* XY_STRESS = "Sigma_xy component";
  static constexpr char const* XZ_STRESS = "Sigma_xz component";
  static constexpr char const* YZ_STRESS = "Sigma_yz component";
  static constexpr char const* XX_STRESS = "Sigma_xx component";
  static constexpr char const* YY_STRESS = "Sigma_yy component";
  static constexpr char const* ZZ_STRESS = "Sigma_zz component";
  static constexpr char const* LEGACY_STRESS = "Legacy Wall Shear Stress";
};