/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/

#pragma once

#include "LBM.h"

#include "itkAffineTransform.h"
#include "itkAutoCropLabelMapFilter.h"
#include "itkImage.h"
#include "itkImageFileReader.h"
#include "itkImageFileWriter.h"
#include "itkImageIOBase.h"
#include "itkImageRegionIteratorWithIndex.h"
#include "itkLabelMapToLabelImageFilter.h"
#include "itkLabelMap.h"
#include "itkLabelImageToLabelMapFilter.h"
#include "itkNearestNeighborInterpolateImageFunction.h"
#include "itkResampleImageFilter.h"

#define LBMITK_TEMPLATE typename PixelType, typename ImageType
#define LBMITK_TYPES PixelType, ImageType

/// Main driving  method that creates and runs a LBMITK based class
LBM_DECL bool RunLBMITK(std::string const& filename, LBM& lbm);

// ITK Methods for extracting a running from a mesh from a medical image
template <LBMITK_TEMPLATE>
class LBM_DECL LBMITK
{
public:
  LBMITK(LBM& lbm);
  virtual ~LBMITK();

  virtual bool Run(std::string const& filename);

  virtual bool ReadImage(std::string const& filename);

  virtual bool WriteImage(std::string const& filename);

  virtual bool CropImage();

  virtual bool OrientImageToX();

  virtual bool NormalizeImage();

  virtual bool DownsampleImage();

protected:

  // Basic types
  using Image = typename ImageType::Pointer;
  using Size = typename ImageType::SizeType;
  using Spacing = typename ImageType::SpacingType;
  using Origin = typename ImageType::PointType;
  using TransformType = itk::AffineTransform<double, 3>;
  // Filter types
  using InterpType = itk::NearestNeighborInterpolateImageFunction<ImageType>;
  using ResampleFilterType = itk::ResampleImageFilter<ImageType, ImageType>;
  // Label Types
  using LabelObjectType = itk::LabelObject<PixelType,3>;
  using LabelMapType = itk::LabelMap<LabelObjectType>;
  using CropType = itk::AutoCropLabelMapFilter<LabelMapType>;
  using CropSize = typename CropType::SizeType;
  using LabelImageToMapFilterType = itk::LabelImageToLabelMapFilter<ImageType, LabelMapType>;
  using LabelMapToImageFilterType = itk::LabelMapToLabelImageFilter<LabelMapType, ImageType>;

  LBM&  m_lbm;
  Image m_image;
};
