/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/

#pragma once
#include <string>
#include <vector>
#include "LBM.h"

///////////////////////////
// Utils specific to LBM //
///////////////////////////

LBM_DECL void GetRunDirectories(std::string const& root, std::vector<std::string>& input, std::vector<std::string>& output);

///////////////////
// Generic Utils //
///////////////////

LBM_DECL bool CreateFilePath(const std::string&);

LBM_DECL void DeleteDirectory(const std::string& dir, bool bDeleteSubdirectories = true);

LBM_DECL std::string GetCurrentWorkingDirectory();

LBM_DECL bool IsDirectory(struct dirent* ent);

LBM_DECL void ListFiles(const std::string& dir, std::vector<std::string>& files, const std::string& mask = "");

LBM_DECL void MakeDirectory(std::string const& dir);

LBM_DECL std::string Replace(const std::string& original, const std::string& replace, const std::string& withThis);
