
macro(add_executable_ex target)
  set (files ${ARGN})
  list(LENGTH files num_files)
    if (${num_files} EQUAL 0)
        message ("No files associated with target ${target}")
    endif ()
  add_executable(${target} ${files})
  set_target_properties(${target} PROPERTIES
    DEBUG_POSTFIX "${CMAKE_DEBUG_POSTFIX}")
  set_target_properties (${target} PROPERTIES 
    FOLDER ${PROJECT_NAME})
  add_custom_command(TARGET ${target} POST_BUILD
                   COMMAND ${CMAKE_COMMAND} -E copy $<TARGET_FILE:${target}> ${${PROJECT_NAME}_INSTALL_BIN_DIR})

  if(MSVC) # Configure running executable out of MSVC
    set_property(TARGET ${target} PROPERTY VS_DEBUGGER_WORKING_DIRECTORY "${${PROJECT_NAME}_INSTALL_BIN_DIR}")
  endif()

endmacro()
