/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestLinePlot.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

// Hide VTK_DEPRECATED_IN_9_0_0() warnings for this class.
#define VTK_DEPRECATION_LEVEL 0

#include "vtkAxis.h"
#include "vtkChartXY.h"
#include "vtkColorTransferFunction.h"
#include "vtkCompositeControlPointsItem.h"
#include "vtkCompositeTransferFunctionItem.h"
#include "vtkContextScene.h"
#include "vtkContextView.h"
#include "vtkFloatArray.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkNew.h"
#include "vtkPiecewiseFunction.h"
#include "vtkPlot.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkTable.h"

static const char* TestControlPointsHandleItemLog = "# StreamVersion 1\n"
                                                    "TimerEvent 0 0 0 0 0 0 0\n"
                                                    "EnterEvent 392 142 0 0 0 0 0\n"
                                                    "MouseMoveEvent 392 142 0 0 0 0 0\n"
                                                    "MouseMoveEvent 388 142 0 0 0 0 0\n"
                                                    "MouseMoveEvent 387 142 0 0 0 0 0\n"
                                                    "TimerEvent 387 142 0 0 0 0 0\n"
                                                    "MouseMoveEvent 384 141 0 0 0 0 0\n"
                                                    "MouseMoveEvent 377 141 0 0 0 0 0\n"
                                                    "MouseMoveEvent 366 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 357 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 348 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 340 139 0 0 0 0 0\n"
                                                    "TimerEvent 340 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 332 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 327 137 0 0 0 0 0\n"
                                                    "MouseMoveEvent 323 137 0 0 0 0 0\n"
                                                    "TimerEvent 323 137 0 0 0 0 0\n"
                                                    "MouseMoveEvent 322 137 0 0 0 0 0\n"
                                                    "MouseMoveEvent 319 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 315 141 0 0 0 0 0\n"
                                                    "MouseMoveEvent 309 146 0 0 0 0 0\n"
                                                    "MouseMoveEvent 303 150 0 0 0 0 0\n"
                                                    "MouseMoveEvent 297 156 0 0 0 0 0\n"
                                                    "TimerEvent 297 156 0 0 0 0 0\n"
                                                    "MouseMoveEvent 291 160 0 0 0 0 0\n"
                                                    "MouseMoveEvent 285 166 0 0 0 0 0\n"
                                                    "MouseMoveEvent 279 171 0 0 0 0 0\n"
                                                    "MouseMoveEvent 275 175 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 177 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 178 0 0 0 0 0\n"
                                                    "TimerEvent 272 178 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 179 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 180 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 182 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 183 0 0 0 0 0\n"
                                                    "TimerEvent 272 183 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 184 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 185 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 185 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 186 0 0 0 0 0\n"
                                                    "TimerEvent 273 186 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 187 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 188 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 189 0 0 0 0 0\n"
                                                    "TimerEvent 273 189 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 190 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 191 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 192 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 193 0 0 0 0 0\n"
                                                    "TimerEvent 274 193 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 194 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 195 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 197 0 0 0 0 0\n"
                                                    "TimerEvent 274 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 275 199 0 0 0 0 0\n"
                                                    "MouseMoveEvent 275 200 0 0 0 0 0\n"
                                                    "TimerEvent 275 200 0 0 0 0 0\n"
                                                    "MouseMoveEvent 275 201 0 0 0 0 0\n"
                                                    "MouseMoveEvent 275 202 0 0 0 0 0\n"
                                                    "TimerEvent 275 202 0 0 0 0 0\n"
                                                    "MouseMoveEvent 274 201 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 200 0 0 0 0 0\n"
                                                    "MouseMoveEvent 269 199 0 0 0 0 0\n"
                                                    "MouseMoveEvent 266 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 264 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 262 197 0 0 0 0 0\n"
                                                    "TimerEvent 262 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 261 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 260 196 0 0 0 0 0\n"
                                                    "TimerEvent 260 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 262 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 266 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 277 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 283 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 287 199 0 0 0 0 0\n"
                                                    "TimerEvent 287 199 0 0 0 0 0\n"
                                                    "MouseMoveEvent 286 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 285 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 285 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 284 197 0 0 0 0 0\n"
                                                    "TimerEvent 284 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 283 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 280 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 278 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 277 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 275 199 0 0 0 0 0\n"
                                                    "TimerEvent 275 199 0 0 0 0 0\n"
                                                    "MouseMoveEvent 273 200 0 0 0 0 0\n"
                                                    "MouseMoveEvent 272 201 0 0 0 0 0\n"
                                                    "MouseMoveEvent 271 202 0 0 0 0 0\n"
                                                    "MouseMoveEvent 270 202 0 0 0 0 0\n"
                                                    "TimerEvent 270 202 0 0 0 0 0\n"
                                                    "MouseMoveEvent 269 202 0 0 0 0 0\n"
                                                    "MouseMoveEvent 269 201 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 200 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 197 0 0 0 0 0\n"
                                                    "TimerEvent 268 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 196 0 0 0 0 0\n"
                                                    "TimerEvent 268 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 199 0 0 0 0 0\n"
                                                    "TimerEvent 268 199 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 268 199 0 0 0 0 0\n"
                                                    "TimerEvent 268 199 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 268 199 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 268 199 0 0 0 1 0\n"
                                                    "TimerEvent 268 199 0 0 0 1 0\n"
                                                    "LeftButtonReleaseEvent 268 199 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 198 0 0 0 0 0\n"
                                                    "MouseMoveEvent 268 197 0 0 0 0 0\n"
                                                    "MouseMoveEvent 267 196 0 0 0 0 0\n"
                                                    "MouseMoveEvent 267 194 0 0 0 0 0\n"
                                                    "MouseMoveEvent 267 193 0 0 0 0 0\n"
                                                    "TimerEvent 267 193 0 0 0 0 0\n"
                                                    "MouseMoveEvent 267 192 0 0 0 0 0\n"
                                                    "MouseMoveEvent 267 191 0 0 0 0 0\n"
                                                    "TimerEvent 267 191 0 0 0 0 0\n"
                                                    "MouseMoveEvent 267 190 0 0 0 0 0\n"
                                                    "MouseMoveEvent 267 189 0 0 0 0 0\n"
                                                    "MouseMoveEvent 266 188 0 0 0 0 0\n"
                                                    "TimerEvent 266 188 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 266 188 0 0 0 0 0\n"
                                                    "MouseMoveEvent 266 187 0 0 0 0 0\n"
                                                    "TimerEvent 266 187 0 0 0 0 0\n"
                                                    "MouseMoveEvent 266 186 0 0 0 0 0\n"
                                                    "TimerEvent 266 186 0 0 0 0 0\n"
                                                    "MouseMoveEvent 266 185 0 0 0 0 0\n"
                                                    "TimerEvent 266 185 0 0 0 0 0\n"
                                                    "MouseMoveEvent 266 184 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 183 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 182 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 181 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 180 0 0 0 0 0\n"
                                                    "TimerEvent 265 180 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 179 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 178 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 177 0 0 0 0 0\n"
                                                    "TimerEvent 265 177 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 176 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 175 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 174 0 0 0 0 0\n"
                                                    "TimerEvent 265 174 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 173 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 172 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 171 0 0 0 0 0\n"
                                                    "TimerEvent 265 171 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 170 0 0 0 0 0\n"
                                                    "TimerEvent 265 170 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 171 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 172 0 0 0 0 0\n"
                                                    "TimerEvent 265 172 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 173 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 174 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 175 0 0 0 0 0\n"
                                                    "TimerEvent 265 175 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 265 175 0 0 0 0 0\n"
                                                    "TimerEvent 265 175 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 174 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 173 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 171 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 170 0 0 0 0 0\n"
                                                    "MouseMoveEvent 265 168 0 0 0 0 0\n"
                                                    "TimerEvent 265 168 0 0 0 0 0\n"
                                                    "MouseMoveEvent 263 166 0 0 0 0 0\n"
                                                    "MouseMoveEvent 256 163 0 0 0 0 0\n"
                                                    "MouseMoveEvent 247 159 0 0 0 0 0\n"
                                                    "MouseMoveEvent 239 157 0 0 0 0 0\n"
                                                    "MouseMoveEvent 232 155 0 0 0 0 0\n"
                                                    "MouseMoveEvent 228 153 0 0 0 0 0\n"
                                                    "TimerEvent 228 153 0 0 0 0 0\n"
                                                    "MouseMoveEvent 227 152 0 0 0 0 0\n"
                                                    "MouseMoveEvent 226 152 0 0 0 0 0\n"
                                                    "MouseMoveEvent 224 151 0 0 0 0 0\n"
                                                    "MouseMoveEvent 222 150 0 0 0 0 0\n"
                                                    "MouseMoveEvent 219 148 0 0 0 0 0\n"
                                                    "MouseMoveEvent 215 147 0 0 0 0 0\n"
                                                    "TimerEvent 215 147 0 0 0 0 0\n"
                                                    "MouseMoveEvent 210 145 0 0 0 0 0\n"
                                                    "MouseMoveEvent 202 142 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 138 0 0 0 0 0\n"
                                                    "MouseMoveEvent 184 135 0 0 0 0 0\n"
                                                    "MouseMoveEvent 177 133 0 0 0 0 0\n"
                                                    "MouseMoveEvent 173 133 0 0 0 0 0\n"
                                                    "TimerEvent 173 133 0 0 0 0 0\n"
                                                    "MouseMoveEvent 173 134 0 0 0 0 0\n"
                                                    "MouseMoveEvent 174 138 0 0 0 0 0\n"
                                                    "MouseMoveEvent 175 146 0 0 0 0 0\n"
                                                    "MouseMoveEvent 175 150 0 0 0 0 0\n"
                                                    "MouseMoveEvent 175 151 0 0 0 0 0\n"
                                                    "TimerEvent 175 151 0 0 0 0 0\n"
                                                    "MouseMoveEvent 175 150 0 0 0 0 0\n"
                                                    "MouseMoveEvent 175 149 0 0 0 0 0\n"
                                                    "MouseMoveEvent 174 148 0 0 0 0 0\n"
                                                    "MouseMoveEvent 172 147 0 0 0 0 0\n"
                                                    "MouseMoveEvent 169 145 0 0 0 0 0\n"
                                                    "MouseMoveEvent 166 143 0 0 0 0 0\n"
                                                    "TimerEvent 166 143 0 0 0 0 0\n"
                                                    "MouseMoveEvent 163 141 0 0 0 0 0\n"
                                                    "MouseMoveEvent 162 140 0 0 0 0 0\n"
                                                    "MouseMoveEvent 160 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 160 138 0 0 0 0 0\n"
                                                    "MouseMoveEvent 159 137 0 0 0 0 0\n"
                                                    "MouseMoveEvent 158 136 0 0 0 0 0\n"
                                                    "TimerEvent 158 136 0 0 0 0 0\n"
                                                    "MouseMoveEvent 156 135 0 0 0 0 0\n"
                                                    "MouseMoveEvent 155 134 0 0 0 0 0\n"
                                                    "MouseMoveEvent 154 133 0 0 0 0 0\n"
                                                    "MouseMoveEvent 152 132 0 0 0 0 0\n"
                                                    "MouseMoveEvent 151 130 0 0 0 0 0\n"
                                                    "MouseMoveEvent 150 129 0 0 0 0 0\n"
                                                    "TimerEvent 150 129 0 0 0 0 0\n"
                                                    "MouseMoveEvent 149 128 0 0 0 0 0\n"
                                                    "MouseMoveEvent 148 127 0 0 0 0 0\n"
                                                    "MouseMoveEvent 148 126 0 0 0 0 0\n"
                                                    "MouseMoveEvent 148 124 0 0 0 0 0\n"
                                                    "MouseMoveEvent 148 123 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 123 0 0 0 0 0\n"
                                                    "TimerEvent 147 123 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 122 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 121 0 0 0 0 0\n"
                                                    "TimerEvent 147 121 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 119 0 0 0 0 0\n"
                                                    "TimerEvent 147 119 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 117 0 0 0 0 0\n"
                                                    "MouseMoveEvent 145 116 0 0 0 0 0\n"
                                                    "MouseMoveEvent 144 115 0 0 0 0 0\n"
                                                    "TimerEvent 144 115 0 0 0 0 0\n"
                                                    "MouseMoveEvent 142 114 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 114 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 112 0 0 0 0 0\n"
                                                    "TimerEvent 134 112 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 134 112 0 0 0 0 0\n"
                                                    "TimerEvent 134 112 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 134 112 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 134 112 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 134 112 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 134 112 0 0 0 1 0\n"
                                                    "TimerEvent 134 112 0 0 0 1 0\n"
                                                    "LeftButtonReleaseEvent 134 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 133 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 132 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 130 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 129 109 0 0 0 0 0\n"
                                                    "TimerEvent 129 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 128 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 122 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 116 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 105 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 97 111 0 0 0 0 0\n"
                                                    "TimerEvent 97 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 91 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 87 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 86 113 0 0 0 0 0\n"
                                                    "TimerEvent 86 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 84 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 78 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 68 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 57 107 0 0 0 0 0\n"
                                                    "MouseMoveEvent 49 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 44 104 0 0 0 0 0\n"
                                                    "TimerEvent 44 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 40 104 0 0 0 0 0\n"
                                                    "TimerEvent 40 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 41 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 42 104 0 0 0 0 0\n"
                                                    "TimerEvent 42 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 44 105 0 0 0 0 0\n"
                                                    "MouseMoveEvent 48 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 54 107 0 0 0 0 0\n"
                                                    "MouseMoveEvent 60 107 0 0 0 0 0\n"
                                                    "MouseMoveEvent 66 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 67 109 0 0 0 0 0\n"
                                                    "TimerEvent 67 109 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 67 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 67 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 70 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 72 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 73 112 0 0 0 0 0\n"
                                                    "TimerEvent 73 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 74 112 0 0 0 0 0\n"
                                                    "TimerEvent 74 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 76 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 77 112 0 0 0 0 0\n"
                                                    "TimerEvent 77 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 77 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 78 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 80 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 81 110 0 0 0 0 0\n"
                                                    "TimerEvent 81 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 81 109 0 0 0 0 0\n"
                                                    "TimerEvent 81 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 84 108 0 0 0 0 0\n"
                                                    "MouseMoveEvent 88 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 90 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 91 105 0 0 0 0 0\n"
                                                    "MouseMoveEvent 92 105 0 0 0 0 0\n"
                                                    "TimerEvent 92 105 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 92 105 0 0 0 0 0\n"
                                                    "TimerEvent 92 105 0 0 0 0 0\n"
                                                    "MouseMoveEvent 98 105 0 0 0 0 0\n"
                                                    "MouseMoveEvent 104 105 0 0 0 0 0\n"
                                                    "MouseMoveEvent 114 103 0 0 0 0 0\n"
                                                    "MouseMoveEvent 127 100 0 0 0 0 0\n"
                                                    "MouseMoveEvent 148 93 0 0 0 0 0\n"
                                                    "MouseMoveEvent 177 86 0 0 0 0 0\n"
                                                    "TimerEvent 177 86 0 0 0 0 0\n"
                                                    "MouseMoveEvent 212 75 0 0 0 0 0\n"
                                                    "MouseMoveEvent 251 64 0 0 0 0 0\n"
                                                    "MouseMoveEvent 302 55 0 0 0 0 0\n"
                                                    "MouseMoveEvent 363 46 0 0 0 0 0\n"
                                                    "LeaveEvent 426 37 0 0 0 0 0\n"
                                                    "TimerEvent 426 37 0 0 0 0 0\n"
                                                    "EnterEvent 237 16 0 0 0 0 0\n"
                                                    "MouseMoveEvent 237 16 0 0 0 0 0\n"
                                                    "MouseMoveEvent 222 33 0 0 0 0 0\n"
                                                    "MouseMoveEvent 211 48 0 0 0 0 0\n"
                                                    "MouseMoveEvent 202 59 0 0 0 0 0\n"
                                                    "MouseMoveEvent 195 66 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 70 0 0 0 0 0\n"
                                                    "TimerEvent 193 70 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 72 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 74 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 75 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 77 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 78 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 79 0 0 0 0 0\n"
                                                    "TimerEvent 193 79 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 81 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 82 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 83 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 84 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 85 0 0 0 0 0\n"
                                                    "TimerEvent 193 85 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 86 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 87 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 88 0 0 0 0 0\n"
                                                    "MouseMoveEvent 194 89 0 0 0 0 0\n"
                                                    "MouseMoveEvent 194 90 0 0 0 0 0\n"
                                                    "MouseMoveEvent 194 91 0 0 0 0 0\n"
                                                    "TimerEvent 194 91 0 0 0 0 0\n"
                                                    "MouseMoveEvent 194 92 0 0 0 0 0\n"
                                                    "MouseMoveEvent 193 93 0 0 0 0 0\n"
                                                    "MouseMoveEvent 191 94 0 0 0 0 0\n"
                                                    "MouseMoveEvent 189 95 0 0 0 0 0\n"
                                                    "MouseMoveEvent 186 96 0 0 0 0 0\n"
                                                    "MouseMoveEvent 182 97 0 0 0 0 0\n"
                                                    "TimerEvent 182 97 0 0 0 0 0\n"
                                                    "MouseMoveEvent 180 98 0 0 0 0 0\n"
                                                    "MouseMoveEvent 175 99 0 0 0 0 0\n"
                                                    "MouseMoveEvent 171 100 0 0 0 0 0\n"
                                                    "MouseMoveEvent 169 100 0 0 0 0 0\n"
                                                    "MouseMoveEvent 166 101 0 0 0 0 0\n"
                                                    "MouseMoveEvent 164 101 0 0 0 0 0\n"
                                                    "TimerEvent 164 101 0 0 0 0 0\n"
                                                    "MouseMoveEvent 163 101 0 0 0 0 0\n"
                                                    "TimerEvent 163 101 0 0 0 0 0\n"
                                                    "MouseMoveEvent 162 101 0 0 0 0 0\n"
                                                    "TimerEvent 162 101 0 0 0 0 0\n"
                                                    "MouseMoveEvent 161 102 0 0 0 0 0\n"
                                                    "MouseMoveEvent 160 102 0 0 0 0 0\n"
                                                    "MouseMoveEvent 158 103 0 0 0 0 0\n"
                                                    "MouseMoveEvent 157 103 0 0 0 0 0\n"
                                                    "MouseMoveEvent 156 104 0 0 0 0 0\n"
                                                    "TimerEvent 156 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 155 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 154 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 154 105 0 0 0 0 0\n"
                                                    "TimerEvent 154 105 0 0 0 0 0\n"
                                                    "MouseMoveEvent 153 105 0 0 0 0 0\n"
                                                    "MouseMoveEvent 151 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 150 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 149 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 149 107 0 0 0 0 0\n"
                                                    "TimerEvent 149 107 0 0 0 0 0\n"
                                                    "MouseMoveEvent 148 107 0 0 0 0 0\n"
                                                    "MouseMoveEvent 147 108 0 0 0 0 0\n"
                                                    "MouseMoveEvent 146 108 0 0 0 0 0\n"
                                                    "TimerEvent 146 108 0 0 0 0 0\n"
                                                    "MouseMoveEvent 145 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 144 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 144 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 143 110 0 0 0 0 0\n"
                                                    "TimerEvent 143 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 142 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 142 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 141 111 0 0 0 0 0\n"
                                                    "TimerEvent 141 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 111 0 0 0 0 0\n"
                                                    "TimerEvent 140 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 108 0 0 0 0 0\n"
                                                    "TimerEvent 138 108 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 108 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 108 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 109 0 0 0 0 0\n"
                                                    "TimerEvent 136 109 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 136 109 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 136 109 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 136 109 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 136 109 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 136 109 0 0 0 1 0\n"
                                                    "TimerEvent 136 109 0 0 0 1 0\n"
                                                    "LeftButtonReleaseEvent 136 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 101 0 0 0 0 0\n"
                                                    "MouseMoveEvent 146 80 0 0 0 0 0\n"
                                                    "MouseMoveEvent 171 59 0 0 0 0 0\n"
                                                    "MouseMoveEvent 218 42 0 0 0 0 0\n"
                                                    "MouseMoveEvent 297 27 0 0 0 0 0\n"
                                                    "LeaveEvent 400 18 0 0 0 0 0\n"
                                                    "TimerEvent 400 18 0 0 0 0 0\n"
                                                    "EnterEvent 392 259 0 0 0 0 0\n"
                                                    "MouseMoveEvent 392 259 0 0 0 0 0\n"
                                                    "MouseMoveEvent 381 264 0 0 0 0 0\n"
                                                    "MouseMoveEvent 370 269 0 0 0 0 0\n"
                                                    "MouseMoveEvent 359 274 0 0 0 0 0\n"
                                                    "MouseMoveEvent 348 279 0 0 0 0 0\n"
                                                    "MouseMoveEvent 339 281 0 0 0 0 0\n"
                                                    "TimerEvent 339 281 0 0 0 0 0\n"
                                                    "MouseMoveEvent 328 284 0 0 0 0 0\n"
                                                    "MouseMoveEvent 319 286 0 0 0 0 0\n"
                                                    "MouseMoveEvent 310 289 0 0 0 0 0\n"
                                                    "MouseMoveEvent 301 292 0 0 0 0 0\n"
                                                    "MouseMoveEvent 296 292 0 0 0 0 0\n"
                                                    "MouseMoveEvent 292 294 0 0 0 0 0\n"
                                                    "TimerEvent 292 294 0 0 0 0 0\n"
                                                    "MouseMoveEvent 288 297 0 0 0 0 0\n"
                                                    "MouseMoveEvent 284 298 0 0 0 0 0\n"
                                                    "MouseMoveEvent 282 299 0 0 0 0 0\n"
                                                    "LeaveEvent 281 300 0 0 0 0 0\n"
                                                    "TimerEvent 281 300 0 0 0 0 0\n"
                                                    "KeyPressEvent 276 304 0 0 98 1 b\n"
                                                    "TimerEvent 0 0 0 0 0 0 0\n"
                                                    "EnterEvent 385 3 0 0 0 0 0\n"
                                                    "MouseMoveEvent 385 3 0 0 0 0 0\n"
                                                    "LeaveEvent 406 10 0 0 0 0 0\n"
                                                    "TimerEvent 406 10 0 0 0 0 0\n"
                                                    "EnterEvent 391 93 0 0 0 0 0\n"
                                                    "MouseMoveEvent 391 93 0 0 0 0 0\n"
                                                    "MouseMoveEvent 372 93 0 0 0 0 0\n"
                                                    "MouseMoveEvent 351 96 0 0 0 0 0\n"
                                                    "MouseMoveEvent 330 99 0 0 0 0 0\n"
                                                    "MouseMoveEvent 309 101 0 0 0 0 0\n"
                                                    "MouseMoveEvent 284 104 0 0 0 0 0\n"
                                                    "TimerEvent 284 104 0 0 0 0 0\n"
                                                    "MouseMoveEvent 263 107 0 0 0 0 0\n"
                                                    "MouseMoveEvent 244 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 229 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 216 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 207 114 0 0 0 0 0\n"
                                                    "MouseMoveEvent 198 116 0 0 0 0 0\n"
                                                    "TimerEvent 198 116 0 0 0 0 0\n"
                                                    "MouseMoveEvent 192 116 0 0 0 0 0\n"
                                                    "MouseMoveEvent 185 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 179 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 173 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 166 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 160 120 0 0 0 0 0\n"
                                                    "TimerEvent 160 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 153 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 146 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 133 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 127 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 121 118 0 0 0 0 0\n"
                                                    "TimerEvent 121 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 120 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 119 118 0 0 0 0 0\n"
                                                    "TimerEvent 119 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 119 117 0 0 0 0 0\n"
                                                    "MouseMoveEvent 119 116 0 0 0 0 0\n"
                                                    "MouseMoveEvent 121 114 0 0 0 0 0\n"
                                                    "MouseMoveEvent 122 114 0 0 0 0 0\n"
                                                    "TimerEvent 122 114 0 0 0 0 0\n"
                                                    "MouseMoveEvent 123 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 124 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 125 113 0 0 0 0 0\n"
                                                    "TimerEvent 125 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 125 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 127 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 129 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 131 110 0 0 0 0 0\n"
                                                    "TimerEvent 131 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 132 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 132 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 133 109 0 0 0 0 0\n"
                                                    "TimerEvent 133 109 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 133 109 0 0 0 0 0\n"
                                                    "TimerEvent 133 109 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 133 109 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 133 109 0 0 0 1 0\n"
                                                    "TimerEvent 133 109 0 0 0 1 0\n"
                                                    "LeftButtonReleaseEvent 133 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 111 0 0 0 0 0\n"
                                                    "TimerEvent 134 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 114 0 0 0 0 0\n"
                                                    "MouseMoveEvent 134 116 0 0 0 0 0\n"
                                                    "TimerEvent 134 116 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 116 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 117 0 0 0 0 0\n"
                                                    "TimerEvent 135 117 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 135 117 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 119 0 0 0 0 0\n"
                                                    "TimerEvent 135 119 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 121 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 122 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 123 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 124 0 0 0 0 0\n"
                                                    "TimerEvent 135 124 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 125 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 126 0 0 0 0 0\n"
                                                    "MouseMoveEvent 135 127 0 0 0 0 0\n"
                                                    "TimerEvent 135 127 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 128 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 130 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 131 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 132 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 133 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 134 0 0 0 0 0\n"
                                                    "TimerEvent 137 134 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 136 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 137 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 138 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 140 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 142 0 0 0 0 0\n"
                                                    "TimerEvent 137 142 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 143 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 144 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 145 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 146 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 147 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 148 0 0 0 0 0\n"
                                                    "TimerEvent 139 148 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 149 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 151 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 152 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 153 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 155 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 156 0 0 0 0 0\n"
                                                    "TimerEvent 140 156 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 157 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 158 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 159 0 0 0 0 0\n"
                                                    "TimerEvent 140 159 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 160 0 0 0 0 0\n"
                                                    "TimerEvent 140 160 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 140 160 0 0 0 0 0\n"
                                                    "TimerEvent 140 160 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 159 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 158 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 157 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 156 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 154 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 153 0 0 0 0 0\n"
                                                    "TimerEvent 140 153 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 152 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 150 0 0 0 0 0\n"
                                                    "MouseMoveEvent 140 149 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 147 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 146 0 0 0 0 0\n"
                                                    "TimerEvent 139 146 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 144 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 143 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 142 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 141 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 140 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 139 0 0 0 0 0\n"
                                                    "TimerEvent 139 139 0 0 0 0 0\n"
                                                    "MouseMoveEvent 139 138 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 136 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 135 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 134 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 133 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 132 0 0 0 0 0\n"
                                                    "TimerEvent 138 132 0 0 0 0 0\n"
                                                    "MouseMoveEvent 138 131 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 130 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 129 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 128 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 127 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 126 0 0 0 0 0\n"
                                                    "TimerEvent 137 126 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 125 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 124 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 123 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 122 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 121 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 120 0 0 0 0 0\n"
                                                    "TimerEvent 137 120 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 119 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 118 0 0 0 0 0\n"
                                                    "MouseMoveEvent 137 117 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 116 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 115 0 0 0 0 0\n"
                                                    "TimerEvent 136 115 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 114 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 113 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 112 0 0 0 0 0\n"
                                                    "TimerEvent 136 112 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 111 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 110 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 109 0 0 0 0 0\n"
                                                    "TimerEvent 136 109 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 108 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 107 0 0 0 0 0\n"
                                                    "TimerEvent 136 107 0 0 0 0 0\n"
                                                    "MouseMoveEvent 136 106 0 0 0 0 0\n"
                                                    "TimerEvent 136 106 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 136 106 0 0 0 0 0\n"
                                                    "LeftButtonReleaseEvent 136 106 0 0 0 0 0\n"
                                                    "LeftButtonPressEvent 136 106 0 0 0 1 0\n"
                                                    "TimerEvent 136 106 0 0 0 1 0\n"
                                                    "LeftButtonReleaseEvent 136 106 0 0 0 0 0\n"
                                                    "MouseMoveEvent 143 94 0 0 0 0 0\n"
                                                    "MouseMoveEvent 171 73 0 0 0 0 0\n"
                                                    "MouseMoveEvent 224 50 0 0 0 0 0\n"
                                                    "MouseMoveEvent 299 29 0 0 0 0 0\n"
                                                    "MouseMoveEvent 388 12 0 0 0 0 0\n"
                                                    "LeaveEvent 489 -5 0 0 0 0 0\n"
                                                    "TimerEvent 489 -5 0 0 0 0 0\n";

//------------------------------------------------------------------------------
int TestControlPointsHandleItem(int, char*[])
{
  // Set up a 2D scene, add an XY chart to it
  vtkNew<vtkContextView> view;
  view->GetRenderer()->SetBackground(1.0, 1.0, 1.0);
  view->GetRenderWindow()->SetSize(400, 300);
  vtkNew<vtkChartXY> chart;
  chart->ForceAxesToBoundsOn();
  chart->SetAutoSize(true);
  chart->SetAutoAxes(false);
  chart->SetHiddenAxisBorder(0);
  //  chart->SetActionToButton(vtkChart::PAN, vtkContextMouseEvent::MIDDLE_BUTTON);
  //  chart->SetActionToButton(vtkChart::SELECT, vtkContextMouseEvent::RIGHT_BUTTON);
  for (int i = 0; i < 4; ++i)
  {
    chart->GetAxis(i)->SetVisible(true);
    chart->GetAxis(i)->SetNumberOfTicks(0);
    chart->GetAxis(i)->SetBehavior(2);
    chart->GetAxis(i)->SetLabelsVisible(false);
    chart->GetAxis(i)->SetMargins(1, 1);
    chart->GetAxis(i)->SetTitle("");
  }

  view->GetScene()->AddItem(chart);

  // Create transfer mapping scalar value to opacity.
  vtkNew<vtkPiecewiseFunction> opacityFunction;
  opacityFunction->AddPoint(0.0, 0.1);
  opacityFunction->AddPoint(0.5, 0.5);
  opacityFunction->AddPoint(1., 1.);

  // Create transfer mapping scalar value to color.
  vtkNew<vtkColorTransferFunction> colorTransferFunction;
  colorTransferFunction->SetColorSpaceToHSV();
  colorTransferFunction->HSVWrapOn();
  colorTransferFunction->AddHSVSegment(0., 0., 1., 1., 0.3333, 0.3333, 1., 1.);
  colorTransferFunction->AddHSVSegment(0.3333, 0.3333, 1., 1., 0.6666, 0.6666, 1., 1.);
  colorTransferFunction->AddHSVSegment(0.6666, 0.6666, 1., 1., 1., 0., 1., 1.);

  colorTransferFunction->Build();

  vtkNew<vtkCompositeTransferFunctionItem> item;
  item->SetColorTransferFunction(colorTransferFunction);
  item->SetOpacityFunction(opacityFunction);
  item->SetMaskAboveCurve(true);
  chart->AddPlot(item);

  vtkNew<vtkCompositeControlPointsItem> controlPoints;
  controlPoints->SetColorTransferFunction(colorTransferFunction);
  controlPoints->SetOpacityFunction(opacityFunction);
  controlPoints->SetEndPointsXMovable(false);
  controlPoints->SetUseOpacityPointHandles(true);
  controlPoints->SetEndPointsRemovable(false);
  chart->AddPlot(controlPoints);

  // Finally render the scene and compare the image to a reference image
  view->GetRenderWindow()->SetMultiSamples(0);

  // recorder to play back previously events
  vtkSmartPointer<vtkInteractorEventRecorder> recorder =
    vtkSmartPointer<vtkInteractorEventRecorder>::New();
  recorder->SetInteractor(view->GetInteractor());
  // recorder->SetKeyPressActivationValue('b');

  recorder->ReadFromInputStringOn();
  recorder->SetInputString(TestControlPointsHandleItemLog);

  view->GetInteractor()->Initialize();
  view->Render();

  recorder->Play();
  // Remove the observers so we can go interactive. Without this the "-I"
  // testing option fails.
  recorder->Off();

  // recorder->SetFileName("record.log");
  // recorder->On();
  // recorder->Record();

  view->GetInteractor()->Initialize();
  view->GetInteractor()->Start();

  return EXIT_SUCCESS;
}
