include(RunCTest)

function(run_InstrumentationInCTestXML CASE_NAME USE_INSTRUMENTATION USE_VERBOSE_INSTRUMENTATION)
  if(USE_VERBOSE_INSTRUMENTATION)
    set(ENV{CTEST_USE_VERBOSE_INSTRUMENTATION} "1")
    set(RunCMake_USE_VERBOSE_INSTRUMENTATION TRUE)
  else()
    set(ENV{CTEST_USE_VERBOSE_INSTRUMENTATION} "0")
    set(RunCMake_USE_VERBOSE_INSTRUMENTATION FALSE)
  endif()
  if(USE_INSTRUMENTATION)
    set(ENV{CTEST_USE_INSTRUMENTATION} "1")
    set(ENV{CTEST_EXPERIMENTAL_INSTRUMENTATION} "d16a3082-c4e1-489b-b90c-55750a334f27")
    set(RunCMake_USE_INSTRUMENTATION TRUE)
    set(CASE_NAME InstrumentationInCTestXML)
  else()
    set(ENV{CTEST_USE_INSTRUMENTATION} "0")
    set(ENV{CTEST_EXPERIMENTAL_INSTRUMENTATION} "0")
    set(RunCMake_USE_INSTRUMENTATION FALSE)
    set(CASE_NAME NoInstrumentationInCTestXML)
  endif()
  configure_file(${RunCMake_SOURCE_DIR}/main.c
                 ${RunCMake_BINARY_DIR}/${CASE_NAME}/main.c COPYONLY)
  run_ctest("${CASE_NAME}")
  unset(RunCMake_USE_LAUNCHERS)
  unset(RunCMake_USE_INSTRUMENTATION)
endfunction()
run_InstrumentationInCTestXML(InstrumentationInCTestXML ON OFF)
run_InstrumentationInCTestXML(VerboseInstrumentationInCTestXML ON ON)
run_InstrumentationInCTestXML(NoInstrumentationInCTestXML OFF OFF)
