# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.

if(UNIX)
  set(CMAKE_HIP_OUTPUT_EXTENSION .o)
else()
  set(CMAKE_HIP_OUTPUT_EXTENSION .obj)
endif()
set(CMAKE_INCLUDE_FLAG_HIP "-I")

# Set implicit links early so compiler-specific modules can use them.
set(__IMPLICIT_LINKS)
foreach(dir ${CMAKE_HIP_HOST_IMPLICIT_LINK_DIRECTORIES})
  string(APPEND __IMPLICIT_LINKS " -L\"${dir}\"")
endforeach()
foreach(lib ${CMAKE_HIP_HOST_IMPLICIT_LINK_LIBRARIES})
  if(${lib} MATCHES "/")
    string(APPEND __IMPLICIT_LINKS " \"${lib}\"")
  else()
    string(APPEND __IMPLICIT_LINKS " -l${lib}")
  endif()
endforeach()

# Load compiler-specific information.
if(CMAKE_HIP_COMPILER_ID)
  include(Compiler/${CMAKE_HIP_COMPILER_ID}-HIP OPTIONAL)
endif()

# load the system- and compiler specific files
if(CMAKE_HIP_COMPILER_ID)
  # load a hardware specific file, mostly useful for embedded compilers
  if(CMAKE_SYSTEM_PROCESSOR)
    include(Platform/${CMAKE_EFFECTIVE_SYSTEM_NAME}-${CMAKE_HIP_COMPILER_ID}-HIP-${CMAKE_SYSTEM_PROCESSOR} OPTIONAL)
  endif()
  include(Platform/${CMAKE_EFFECTIVE_SYSTEM_NAME}-${CMAKE_HIP_COMPILER_ID}-HIP OPTIONAL)
endif()


if(NOT CMAKE_SHARED_LIBRARY_RUNTIME_HIP_FLAG)
  set(CMAKE_SHARED_LIBRARY_RUNTIME_HIP_FLAG ${CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG})
endif()

if(NOT CMAKE_SHARED_LIBRARY_RUNTIME_HIP_FLAG_SEP)
  set(CMAKE_SHARED_LIBRARY_RUNTIME_HIP_FLAG_SEP ${CMAKE_SHARED_LIBRARY_RUNTIME_C_FLAG_SEP})
endif()

if(NOT CMAKE_SHARED_LIBRARY_RPATH_LINK_HIP_FLAG)
  set(CMAKE_SHARED_LIBRARY_RPATH_LINK_HIP_FLAG ${CMAKE_SHARED_LIBRARY_RPATH_LINK_C_FLAG})
endif()

if(NOT DEFINED CMAKE_EXE_EXPORTS_HIP_FLAG)
  set(CMAKE_EXE_EXPORTS_HIP_FLAG ${CMAKE_EXE_EXPORTS_C_FLAG})
endif()

if(NOT DEFINED CMAKE_SHARED_LIBRARY_SONAME_HIP_FLAG)
  set(CMAKE_SHARED_LIBRARY_SONAME_HIP_FLAG ${CMAKE_SHARED_LIBRARY_SONAME_C_FLAG})
endif()

if(NOT CMAKE_EXECUTABLE_RUNTIME_HIP_FLAG)
  set(CMAKE_EXECUTABLE_RUNTIME_HIP_FLAG ${CMAKE_SHARED_LIBRARY_RUNTIME_HIP_FLAG})
endif()

if(NOT CMAKE_EXECUTABLE_RUNTIME_HIP_FLAG_SEP)
  set(CMAKE_EXECUTABLE_RUNTIME_HIP_FLAG_SEP ${CMAKE_SHARED_LIBRARY_RUNTIME_HIP_FLAG_SEP})
endif()

if(NOT CMAKE_EXECUTABLE_RPATH_LINK_HIP_FLAG)
  set(CMAKE_EXECUTABLE_RPATH_LINK_HIP_FLAG ${CMAKE_SHARED_LIBRARY_RPATH_LINK_HIP_FLAG})
endif()

if(NOT DEFINED CMAKE_SHARED_LIBRARY_LINK_HIP_WITH_RUNTIME_PATH)
  set(CMAKE_SHARED_LIBRARY_LINK_HIP_WITH_RUNTIME_PATH ${CMAKE_SHARED_LIBRARY_LINK_C_WITH_RUNTIME_PATH})
endif()


# for most systems a module is the same as a shared library
# so unless the variable CMAKE_MODULE_EXISTS is set just
# copy the values from the LIBRARY variables
if(NOT CMAKE_MODULE_EXISTS)
  set(CMAKE_SHARED_MODULE_HIP_FLAGS ${CMAKE_SHARED_LIBRARY_HIP_FLAGS})
  set(CMAKE_SHARED_MODULE_CREATE_HIP_FLAGS ${CMAKE_SHARED_LIBRARY_CREATE_HIP_FLAGS})
endif()

if(CMAKE_EXECUTABLE_FORMAT STREQUAL "ELF")
  if(NOT DEFINED CMAKE_HIP_LINK_WHAT_YOU_USE_FLAG)
    set(CMAKE_HIP_LINK_WHAT_YOU_USE_FLAG "LINKER:--no-as-needed")
  endif()
  if(NOT DEFINED CMAKE_LINK_WHAT_YOU_USE_CHECK)
    set(CMAKE_LINK_WHAT_YOU_USE_CHECK ldd -u -r)
  endif()
endif()

# add the flags to the cache based
# on the initial values computed in the platform/*.cmake files
# use _INIT variables so that this only happens the first time
# and you can set these flags in the cmake cache
set(CMAKE_HIP_FLAGS_INIT "$ENV{HIPFLAGS} ${CMAKE_HIP_FLAGS_INIT}")

cmake_initialize_per_config_variable(CMAKE_HIP_FLAGS "Flags used by the HIP compiler")

if(CMAKE_HIP_STANDARD_LIBRARIES_INIT)
  set(CMAKE_HIP_STANDARD_LIBRARIES "${CMAKE_HIP_STANDARD_LIBRARIES_INIT}"
    CACHE STRING "Libraries linked by default with all HIP applications.")
  mark_as_advanced(CMAKE_HIP_STANDARD_LIBRARIES)
endif()

if(NOT CMAKE_HIP_COMPILER_LAUNCHER AND DEFINED ENV{CMAKE_HIP_COMPILER_LAUNCHER})
  set(CMAKE_HIP_COMPILER_LAUNCHER "$ENV{CMAKE_HIP_COMPILER_LAUNCHER}"
    CACHE STRING "Compiler launcher for HIP.")
endif()

include(CMakeCommonLanguageInclude)

# now define the following rules:
# CMAKE_HIP_CREATE_SHARED_LIBRARY
# CMAKE_HIP_CREATE_SHARED_MODULE
# CMAKE_HIP_COMPILE_OBJECT
# CMAKE_HIP_LINK_EXECUTABLE

# create a shared library
if(NOT CMAKE_HIP_CREATE_SHARED_LIBRARY)
  # set(CMAKE_HIP_CREATE_SHARED_LIBRARY
  #     "<CMAKE_HIP_COMPILER> <CMAKE_SHARED_LIBRARY_HIP_FLAGS> <LANGUAGE_COMPILE_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_HIP_FLAGS> <SONAME_FLAG><TARGET_SONAME> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")
  set(CMAKE_HIP_CREATE_SHARED_LIBRARY ${CMAKE_CXX_CREATE_SHARED_LIBRARY})
endif()

# create a shared module copy the shared library rule by default
if(NOT CMAKE_HIP_CREATE_SHARED_MODULE)
  set(CMAKE_HIP_CREATE_SHARED_MODULE ${CMAKE_HIP_CREATE_SHARED_LIBRARY})
endif()

# Create a static archive incrementally for large object file counts.
if(NOT DEFINED CMAKE_HIP_ARCHIVE_CREATE)
  set(CMAKE_HIP_ARCHIVE_CREATE "<CMAKE_AR> qc <TARGET> <LINK_FLAGS> <OBJECTS>")
endif()
if(NOT DEFINED CMAKE_HIP_ARCHIVE_APPEND)
  set(CMAKE_HIP_ARCHIVE_APPEND "<CMAKE_AR> q <TARGET> <LINK_FLAGS> <OBJECTS>")
endif()
if(NOT DEFINED CMAKE_HIP_ARCHIVE_FINISH)
  set(CMAKE_HIP_ARCHIVE_FINISH "<CMAKE_RANLIB> <TARGET>")
endif()

# compile a HIP file into an object file
include(CMakePrintHelpers)
cmake_print_variables(CMAKE_HIP_COMPILER CMAKE_HIP_ARCHITECTURES CMAKE_HIP_FLAGS)
if(NOT CMAKE_HIP_COMPILE_OBJECT)
  # foreach(HIP_ARCH ${CMAKE_HIP_ARCHITECTURES})
  #   list(APPEND CMAKE_HIP_COMPILE_OBJECT
  #     "<CMAKE_HIP_COMPILER> ${_CMAKE_HIP_EXTRA_FLAGS} <DEFINES> <INCLUDES> <FLAGS> -fgpu-rdc --offload-device-only --offload-arch=${HIP_ARCH} -o <SOURCE>.${HIP_ARCH}.bc ${_CMAKE_COMPILE_AS_HIP_FLAG} -c <SOURCE>")
  # endforeach()

  # list(APPEND CMAKE_HIP_COMPILE_OBJECT
  #   "<CMAKE_HIP_COMPILER> ${_CMAKE_HIP_EXTRA_FLAGS} <DEFINES> <INCLUDES> <FLAGS> -fgpu-rdc -o <OBJECT> ${_CMAKE_COMPILE_AS_HIP_FLAG} -Xclang -fcuda-include-gpubinary -Xclang <SOURCE>.hipfb -c <SOURCE>")

  list(APPEND CMAKE_HIP_COMPILE_OBJECT
    "<CMAKE_HIP_COMPILER> ${_CMAKE_HIP_EXTRA_FLAGS} <DEFINES> <INCLUDES> <FLAGS> -o <OBJECT> ${_CMAKE_COMPILE_AS_HIP_FLAG} -c <SOURCE>")
else()
  cmake_print_variables(CMAKE_HIP_COMPILE_OBJECT)
endif()

if(NOT CMAKE_HIP_COMPILE_BC)
  list(APPEND CMAKE_HIP_COMPILE_BC
    "<CMAKE_HIP_COMPILER> ${_CMAKE_HIP_EXTRA_FLAGS} <FLAGS> -o <OBJECT> --target=amdgcn-amd-amdhsa -fgpu-rdc -x ir <SOURCE>")
endif()

if(NOT CMAKE_HIP_OFFLOAD_BUNDLE)
  list(APPEND CMAKE_HIP_OFFLOAD_BUNDLE
    "<CMAKE_HIP_COMPILER>-offload-bundler <FLAGS> -type=o -bundle-align=4096 -output <OBJECT>")
endif()

# compile a cu file into an executable
if(NOT CMAKE_HIP_LINK_EXECUTABLE)
  # set(CMAKE_HIP_LINK_EXECUTABLE
  #   "<CMAKE_HIP_COMPILER> <FLAGS> <CMAKE_HIP_LINK_FLAGS> <LINK_FLAGS> <OBJECTS> -o <TARGET> <LINK_LIBRARIES>")
  set(CMAKE_HIP_LINK_EXECUTABLE ${CMAKE_CXX_LINK_EXECUTABLE})
endif()

set(CMAKE_HIP_INFORMATION_LOADED 1)

# Load the file and find the relevant HIP runtime.
if(NOT DEFINED _CMAKE_HIP_DEVICE_RUNTIME_TARGET)
  set(hip-lang_DIR "${CMAKE_HIP_COMPILER_ROCM_LIB}/cmake/hip-lang")
  find_package(hip-lang CONFIG QUIET NO_DEFAULT_PATH REQUIRED)
endif()
# if(DEFINED _CMAKE_HIP_DEVICE_RUNTIME_TARGET)
#   list(APPEND CMAKE_HIP_RUNTIME_LIBRARIES_STATIC ${_CMAKE_HIP_DEVICE_RUNTIME_TARGET})
#   list(APPEND CMAKE_HIP_RUNTIME_LIBRARIES_SHARED ${_CMAKE_HIP_DEVICE_RUNTIME_TARGET})
# endif()
