# This maintains the links for all sources used by this superbuild.
# Simply update this file to change the revision.
# One can use different revision on different platforms.
# e.g.
# if (UNIX)
#   ..
# else (APPLE)
#   ..
# endif()

add_revision(zlib
  URL "http://www.paraview.org/files/dependencies/zlib-1.2.7.tar.gz"
  URL_MD5 60df6a37c56e7c1366cca812414f7b85)
# NOTE: if updating zlib version, fix patch in zlib.cmake


add_revision(png
  URL "http://paraview.org/files/dependencies/libpng-1.4.8.tar.gz"
  URL_MD5 49c6e05be5fa88ed815945d7ca7d4aa9)

add_revision(freetype
  URL "http://paraview.org/files/dependencies/freetype-2.4.8.tar.gz"
  URL_MD5 "5d82aaa9a4abc0ebbd592783208d9c76")

add_revision(szip
  URL "http://paraview.org/files/dependencies/szip-2.1.tar.gz"
  URL_MD5 902f831bcefb69c6b635374424acbead)

add_revision(hdf5
  URL "http://paraview.org/files/dependencies/hdf5-1.8.9.tar.gz"
  URL_MD5 d1266bb7416ef089400a15cc7c963218)

add_revision(libxml2
  URL "http://paraview.org/files/dependencies/libxml2-2.7.8.tar.gz"
  URL_MD5 8127a65e8c3b08856093099b52599c86)

add_revision(fontconfig
  URL "http://paraview.org/files/dependencies/fontconfig-2.8.0.tar.gz"
  URL_MD5 77e15a92006ddc2adbb06f840d591c0e)

if (WIN32)
  if (64bit_build)
    add_revision(python
      URL     "http://www.computationalmodelbuilder.org/files/dependencies/python+deps.tar.bz2"
      URL_MD5 0b0ceb15fee34dae011f90570888c429)
  else ()
    add_revision(python
      URL     "http://www.computationalmodelbuilder.org/files/dependencies/python+deps-x32.tar.bz2"
      URL_MD5 df1438352768caecf929d7bc2bdf841c)
  endif ()
elseif (CROSS_BUILD_STAGE STREQUAL "CROSS")
  add_revision(python
    URL     "http://www.paraview.org/files/dependencies/Python-2.7.3.tgz"
    URL_MD5 2cf641732ac23b18d139be077bd906cd)
else()
  add_revision(python
    URL     "http://paraview.org/files/dependencies/Python-2.7.2.tgz"
    URL_MD5 0ddfe265f1b3d0a8c2459f5bf66894c7)
endif()

add_revision(numpy
  URL "http://paraview.org/files/dependencies/numpy-1.6.2.tar.gz"
  URL_MD5 95ed6c9dcc94af1fc1642ea2a33c1bba)

add_revision(boost
  URL "http://www.paraview.org/files/dependencies/boost_1_50_0.tar.gz"
  URL_MD5 dbc07ab0254df3dda6300fd737b3f264)

option(USE_VTK_MASTER "Use the master VTK branch" OFF)
cmake_dependent_option(BUILD_VTK7 "Build VTK 7" ON
  "NOT USE_VTK_MASTER" OFF)
if (USE_VTK_MASTER)
  set(vtk_tag "master")
else ()
  set(vtk_tag "v${vtk_version_tag}")
endif ()
add_revision(vtk
  GIT_REPOSITORY https://gitlab.kitware.com/vtk/vtk.git
  GIT_TAG "${vtk_tag}")

# set (VTK_URL "http://www.vtk.org/files/release/6.1/VTK-6.1.0.tar.gz" CACHE STRING "URL to grab vtk tarball from")
# set (VTK_URL_MD5 "7117afdcccc013e3d6b77e99c2012a79" CACHE STRING "MD5 of the VTK tarball")
# add_revision(vtk URL ${VTK_URL})# URL_MD5 ${VTK_URL_MD5})

