/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.navigation;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.j3d.ui.navigation.NavigationStateListener;
import org.j3d.util.ImageLoader;

public class NavigationToolbar
extends JPanel
implements ActionListener,
NavigationStateListener {
    private static final String PAN_BUTTON = "images/navigation/ButtonPan.gif";
    private static final String TILT_BUTTON = "images/navigation/ButtonTilt.gif";
    private static final String FLY_BUTTON = "images/navigation/ButtonFly.gif";
    private static final String WALK_BUTTON = "images/navigation/ButtonWalk.gif";
    private static final String EXAMINE_BUTTON = "images/navigation/ButtonExamine.gif";
    private int navigationState = 4;
    private NavigationStateListener navigationListener;
    private ButtonGroup navStateGroup;
    private JToggleButton flyButton;
    private JToggleButton tiltButton;
    private JToggleButton panButton;
    private JToggleButton walkButton;
    private JToggleButton examineButton;
    private JToggleButton lastButton;
    private boolean allowUserSelect;

    public NavigationToolbar() {
        this(true);
    }

    public NavigationToolbar(boolean bl) {
        if (bl) {
            this.setLayout(new GridLayout(1, 3));
        } else {
            this.setLayout(new GridLayout(3, 1));
        }
        this.navStateGroup = new ButtonGroup();
        Icon icon = ImageLoader.loadIcon(FLY_BUTTON);
        this.flyButton = new JToggleButton(icon, false);
        this.flyButton.setMargin(new Insets(0, 0, 0, 0));
        this.flyButton.setToolTipText("Fly");
        this.flyButton.addActionListener(this);
        this.navStateGroup.add(this.flyButton);
        this.add(this.flyButton);
        icon = ImageLoader.loadIcon(TILT_BUTTON);
        this.tiltButton = new JToggleButton(icon, false);
        this.tiltButton.setMargin(new Insets(0, 0, 0, 0));
        this.tiltButton.setToolTipText("Tilt");
        this.tiltButton.addActionListener(this);
        this.navStateGroup.add(this.tiltButton);
        this.add(this.tiltButton);
        icon = ImageLoader.loadIcon(PAN_BUTTON);
        this.panButton = new JToggleButton(icon, false);
        this.panButton.setMargin(new Insets(0, 0, 0, 0));
        this.panButton.setToolTipText("Pan");
        this.panButton.addActionListener(this);
        this.navStateGroup.add(this.panButton);
        this.add(this.panButton);
        icon = ImageLoader.loadIcon(WALK_BUTTON);
        this.walkButton = new JToggleButton(icon, false);
        this.walkButton.setMargin(new Insets(0, 0, 0, 0));
        this.walkButton.setToolTipText("Walk");
        this.walkButton.addActionListener(this);
        this.navStateGroup.add(this.walkButton);
        this.add(this.walkButton);
        icon = ImageLoader.loadIcon(EXAMINE_BUTTON);
        this.examineButton = new JToggleButton(icon, false);
        this.examineButton.setMargin(new Insets(0, 0, 0, 0));
        this.examineButton.setToolTipText("Examine");
        this.examineButton.addActionListener(this);
        this.navStateGroup.add(this.examineButton);
        this.add(this.examineButton);
        this.allowUserSelect = false;
        this.setEnabled(false);
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navigationListener = navigationStateListener;
    }

    public void setAllowUserStateChange(boolean bl) {
        this.allowUserSelect = bl;
        this.setEnabled(this.allowUserSelect);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.allowUserSelect) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.flyButton) {
            this.navigationState = 4;
            if (this.navigationListener != null) {
                this.navigationListener.setNavigationState(this.navigationState);
            }
        } else if (object == this.tiltButton) {
            this.navigationState = 2;
            if (this.navigationListener != null) {
                this.navigationListener.setNavigationState(this.navigationState);
            }
        } else if (object == this.panButton) {
            this.navigationState = 3;
            if (this.navigationListener != null) {
                this.navigationListener.setNavigationState(this.navigationState);
            }
        } else if (object == this.walkButton) {
            this.navigationState = 1;
            if (this.navigationListener != null) {
                this.navigationListener.setNavigationState(this.navigationState);
            }
        } else if (object == this.examineButton) {
            this.navigationState = 5;
            if (this.navigationListener != null) {
                this.navigationListener.setNavigationState(this.navigationState);
            }
        }
    }

    public void setNavigationState(int n) {
        this.navigationState = n;
        switch (this.navigationState) {
            case 4: {
                this.flyButton.setSelected(true);
                this.lastButton = this.flyButton;
                break;
            }
            case 3: {
                this.panButton.setSelected(true);
                this.lastButton = this.panButton;
                break;
            }
            case 2: {
                this.tiltButton.setSelected(true);
                this.lastButton = this.tiltButton;
                break;
            }
            case 1: {
                this.walkButton.setSelected(true);
                this.lastButton = this.walkButton;
                break;
            }
            case 5: {
                this.examineButton.setSelected(true);
                this.lastButton = this.examineButton;
                break;
            }
            case 0: {
                if (this.lastButton == null) break;
                this.lastButton.setSelected(false);
            }
        }
    }

    public int getNavigationState() {
        return this.navigationState;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.examineButton.setEnabled(bl);
        this.flyButton.setEnabled(bl);
        this.walkButton.setEnabled(bl);
        this.panButton.setEnabled(bl);
        this.tiltButton.setEnabled(bl);
    }
}

