SET(VTK_REQUIRED_C_FLAGS)
SET(VTK_REQUIRED_CXX_FLAGS)

# make sure Crun is linked in with the native compiler, it is
# not used by default for shared libraries and is required for
# things like java to work.
IF(CMAKE_SYSTEM MATCHES "SunOS.*")
  IF(NOT CMAKE_COMPILER_IS_GNUCXX)
    FIND_LIBRARY(VTK_SUNCC_CRUN_LIBRARY Crun /opt/SUNWspro/lib)
    IF(VTK_SUNCC_CRUN_LIBRARY)
      LINK_LIBRARIES(${VTK_SUNCC_CRUN_LIBRARY})
    ENDIF(VTK_SUNCC_CRUN_LIBRARY)
    FIND_LIBRARY(VTK_SUNCC_CSTD_LIBRARY Cstd /opt/SUNWspro/lib)
    IF(VTK_SUNCC_CSTD_LIBRARY)
      LINK_LIBRARIES(${VTK_SUNCC_CSTD_LIBRARY})
    ENDIF(VTK_SUNCC_CSTD_LIBRARY)
  ENDIF(NOT CMAKE_COMPILER_IS_GNUCXX)
ENDIF(CMAKE_SYSTEM MATCHES "SunOS.*")

# A GCC compiler.
IF(CMAKE_COMPILER_IS_GNUCXX)
  # Quiet warning about strstream deprecation if appropriate.
  IF(NOT VTK_LEGACY_REMOVE)
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -Wno-deprecated")
  ENDIF(NOT VTK_LEGACY_REMOVE)
  IF(WIN32)
# The platform is gcc on cygwin.
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -mwin32")
    SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} -mwin32")
    LINK_LIBRARIES(-lgdi32)
  ENDIF(WIN32)
  IF(MINGW)
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -mthreads")
    SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} -mthreads")
    SET(VTK_REQUIRED_EXE_LINKER_FLAGS "${VTK_REQUIRED_EXE_LINKER_FLAGS} -mthreads")
    SET(VTK_REQUIRED_SHARED_LINKER_FLAGS "${VTK_REQUIRED_SHARED_LINKER_FLAGS} -mthreads")
    SET(VTK_REQUIRED_MODULE_LINKER_FLAGS "${VTK_REQUIRED_MODULE_LINKER_FLAGS} -mthreads")
  ENDIF(MINGW)
  IF(CMAKE_SYSTEM MATCHES "SunOS.*")
# Disable warnings that occur in X11 headers.
    IF(DART_ROOT AND BUILD_TESTING)
      SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -Wno-unknown-pragmas")
      SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} -Wno-unknown-pragmas")
    ENDIF(DART_ROOT AND BUILD_TESTING)
  ENDIF(CMAKE_SYSTEM MATCHES "SunOS.*")
ELSE(CMAKE_COMPILER_IS_GNUCXX)
  IF(CMAKE_ANSI_CFLAGS)
    SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} ${CMAKE_ANSI_CFLAGS}")
  ENDIF(CMAKE_ANSI_CFLAGS)
  IF(CMAKE_SYSTEM MATCHES "OSF1-V.*")
     SET(VTK_REQUIRED_CXX_FLAGS
         "${VTK_REQUIRED_CXX_FLAGS} -timplicit_local -no_implicit_include")
  ENDIF(CMAKE_SYSTEM MATCHES "OSF1-V.*")
  IF(CMAKE_SYSTEM MATCHES "IRIX.*")
    SET(VTK_REQUIRED_CXX_FLAGS
      "${VTK_REQUIRED_CXX_FLAGS} -Wl,-woff84 -woff 15 -woff 84 -woff 3439 -woff 1424 -woff 3201")
    SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} -woff 3439")
  ENDIF(CMAKE_SYSTEM MATCHES "IRIX.*")
  IF(CMAKE_SYSTEM MATCHES "AIX.*")
    # allow t-ypeid and d-ynamic_cast usage (normally off by default on xlC)
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -qrtti=all")
    # silence duplicate symbol warnings on AIX
    SET(VTK_REQUIRED_EXE_LINKER_FLAGS "${VTK_REQUIRED_EXE_LINKER_FLAGS} -bhalt:5")
    SET(VTK_REQUIRED_SHARED_LINKER_FLAGS "${VTK_REQUIRED_SHARED_LINKER_FLAGS} -bhalt:5")
    SET(VTK_REQUIRED_MODULE_LINKER_FLAGS "${VTK_REQUIRED_MODULE_LINKER_FLAGS} -bhalt:5")
  ENDIF(CMAKE_SYSTEM MATCHES "AIX.*")
  IF(CMAKE_SYSTEM MATCHES "HP-UX.*")
     SET(VTK_REQUIRED_C_FLAGS
         "${VTK_REQUIRED_C_FLAGS} +W2111 +W2236 +W4276")
     SET(VTK_REQUIRED_CXX_FLAGS
         "${VTK_REQUIRED_CXX_FLAGS} +W2111 +W2236 +W4276")
  ENDIF(CMAKE_SYSTEM MATCHES "HP-UX.*")
ENDIF(CMAKE_COMPILER_IS_GNUCXX)

IF(APPLE)
  # Darwin versions:
  #   6.x == Mac OSX 10.2
  #   7.x == Mac OSX 10.3
  #   8.x == Mac OSX 10.4
  #   9.x == Mac OSX 10.5
  STRING(REGEX REPLACE "^([0-9]+)\\.([0-9]+).*$" "\\1" DARWIN_MAJOR_VERSION "${CMAKE_SYSTEM_VERSION}")
  # Starting 10.4, Tcl/Tk now uses dlopen(RLTD_LOCAL) to load dylib libraries.
  # While they could not be convinced to use the default RLTD_GLOBAL, they
  # suggested the workaround was to stop using -flat_namespace.
  # see https://sourceforge.net/tracker/?func=detail&atid=110894&aid=1961211&group_id=10894
  IF("${DARWIN_MAJOR_VERSION}" LESS 8)
    SET(CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS 
      "${CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS} -Wl,-flat_namespace,-U,_environ")
    SET(CMAKE_SHARED_MODULE_CREATE_C_FLAGS 
      "${CMAKE_SHARED_MODULE_CREATE_C_FLAGS} -Wl,-flat_namespace,-U,_environ")
  ENDIF("${DARWIN_MAJOR_VERSION}" LESS 8)
  IF(CMAKE_COMPILER_IS_GNUCXX)
    # -no-cpp-precomp was a compiler flag present only in Apple's gcc and not
    # in the FSF gcc. The flag is obsolete and totally removed in gcc 4.2
    # and later. I believe it is only needed with gcc 3.3 and earlier.
    INCLUDE(${VTK_SOURCE_DIR}/CMake/vtkCheckCXXAcceptsFlags.cmake)
    vtkCHECK_CXX_ACCEPTS_FLAGS("-no-cpp-precomp" CXX_HAS_CPP_PRECOMP_FLAG)
    IF(${CXX_HAS_CPP_PRECOMP_FLAG})
      SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} -no-cpp-precomp")
      SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -no-cpp-precomp")
    ENDIF(${CXX_HAS_CPP_PRECOMP_FLAG})
    IF(NOT BUILD_SHARED_LIBS)
      SET(VTK_REQUIRED_C_FLAGS "${VTK_REQUIRED_C_FLAGS} -mlong-branch")
      SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -mlong-branch")
    ENDIF(NOT BUILD_SHARED_LIBS)
  ENDIF(CMAKE_COMPILER_IS_GNUCXX)
ENDIF(APPLE)

# figure out whether the compiler might be the Intel compiler
SET(_MAY_BE_INTEL_COMPILER FALSE)
IF(UNIX)
  IF(CMAKE_CXX_COMPILER_ID)
    IF(CMAKE_CXX_COMPILER_ID MATCHES Intel)
      SET(_MAY_BE_INTEL_COMPILER TRUE)
    ENDIF(CMAKE_CXX_COMPILER_ID MATCHES Intel)
  ELSE(CMAKE_CXX_COMPILER_ID)
    IF(NOT CMAKE_COMPILER_IS_GNUCXX)
      SET(_MAY_BE_INTEL_COMPILER TRUE)
    ENDIF(NOT CMAKE_COMPILER_IS_GNUCXX)
  ENDIF(CMAKE_CXX_COMPILER_ID)
ENDIF(UNIX)

#if so, test whether -i_dynamic is needed
IF(_MAY_BE_INTEL_COMPILER)
  INCLUDE(${VTK_CMAKE_DIR}/TestNO_ICC_IDYNAMIC_NEEDED.cmake)
  TESTNO_ICC_IDYNAMIC_NEEDED(NO_ICC_IDYNAMIC_NEEDED ${VTK_CMAKE_DIR})
  IF(NO_ICC_IDYNAMIC_NEEDED)
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS}")
  ELSE(NO_ICC_IDYNAMIC_NEEDED)
    SET(VTK_REQUIRED_CXX_FLAGS "${VTK_REQUIRED_CXX_FLAGS} -i_dynamic")
  ENDIF(NO_ICC_IDYNAMIC_NEEDED)
ENDIF(_MAY_BE_INTEL_COMPILER)


IF(CMAKE_BUILD_TOOL MATCHES "(msdev|devenv|nmake|VCExpress)")
# Use the highest warning level for visual studio.
  SET(CMAKE_CXX_WARNING_LEVEL 4)
  IF(CMAKE_CXX_FLAGS MATCHES "/W[0-4]")
    STRING(REGEX REPLACE "/W[0-4]" "/W4" CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS}")
  ELSE(CMAKE_CXX_FLAGS MATCHES "/W[0-4]")
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /W4")
  ENDIF(CMAKE_CXX_FLAGS MATCHES "/W[0-4]")
ENDIF(CMAKE_BUILD_TOOL MATCHES "(msdev|devenv|nmake|VCExpress)")

# Disable deprecation warnings for standard C and STL functions in VS2005
# and later
IF(MSVC_VERSION EQUAL 1400 OR MSVC_VERSION GREATER 1400)
  ADD_DEFINITIONS(-D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE -D_CRT_SECURE_NO_WARNINGS)
  ADD_DEFINITIONS(-D_SCL_SECURE_NO_DEPRECATE -D_SCL_SECURE_NO_WARNINGS) 
ENDIF(MSVC_VERSION EQUAL 1400 OR MSVC_VERSION GREATER 1400) 

# Enable /MP flag for Visual Studio 2008 and greator
IF(MSVC_VERSION GREATER 1400)
  SET(CMAKE_CXX_MP_FLAG OFF CACHE BOOL "Build with /MP flag enabled")
  SET(PROCESSOR_COUNT "$ENV{NUMBER_OF_PROCESSORS}")
  SET(CMAKE_CXX_MP_NUM_PROCESSORS CACHE ${PROCESSOR_COUNT} "The maximum number of processes for the /MP flag")
  IF (CMAKE_CXX_MP_FLAG)
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} /MP${CMAKE_CXX_MP_NUM_PROCESSORS}")
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} /MP${CMAKE_CXX_MP_NUM_PROCESSORS}")
  ENDIF (CMAKE_CXX_MP_FLAG)
ENDIF(MSVC_VERSION GREATER 1400)
#-----------------------------------------------------------------------------
# Add compiler flags VTK needs to work on this platform.  This must be
# done after the call to CMAKE_EXPORT_BUILD_SETTINGS, but before any
# try-compiles are done.
SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${VTK_REQUIRED_C_FLAGS}")
SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${VTK_REQUIRED_CXX_FLAGS}")
SET(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${VTK_REQUIRED_EXE_LINKER_FLAGS}")
SET(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} ${VTK_REQUIRED_SHARED_LINKER_FLAGS}")
SET(CMAKE_MODULE_LINKER_FLAGS "${CMAKE_MODULE_LINKER_FLAGS} ${VTK_REQUIRED_MODULE_LINKER_FLAGS}")
