#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* warning this code is also in getclasses.cxx under pcmaker */
/* this roputine creates the init file */
static void CreateInitFile(const char *libName, 
  int numConcrete, char **concrete, 
  FILE *fout) 
{
  int i;

  fprintf(fout,"// Generated by vtkWrapPythonInit in VTK/Wrapping\n");
  fprintf(fout,"#include \"vtkPython.h\"\n\n");
  fprintf(fout,"#include \"vtkSystemIncludes.h\"\n");
  fprintf(fout,"#include <string.h>\n");
  fprintf(fout,"// Handle compiler warning messages, etc.\n"
          "#if defined( _MSC_VER ) && !defined(VTK_DISPLAY_WIN32_WARNINGS)\n"
          "#pragma warning ( disable : 4706 )\n"
          "#endif // Windows Warnings \n\n");
  
for (i = 0; i < numConcrete; i++)
    {
#ifdef _WIN32
    fprintf(fout,"extern  \"C\" {__declspec( dllexport) PyObject *PyVTKClass_%sNew(char *); }\n", concrete[i]);
#else
    fprintf(fout,"extern  \"C\" {PyObject *PyVTKClass_%sNew(char *); }\n",concrete[i]);
#endif
    }
  
  fprintf(fout,"\nstatic PyMethodDef Py%s_ClassMethods[] = {\n",
    libName);
  fprintf(fout,"{NULL, NULL, 0, NULL}};\n\n");
  
#ifdef _WIN32
  fprintf(fout,"extern  \"C\" {__declspec( dllexport) void init%s();}\n\n",libName);
  fprintf(fout,"void init%s()\n{\n",libName);
#else
  fprintf(fout,"extern  \"C\" {void initlib%s();}\n\n",libName);
  fprintf(fout,"void initlib%s()\n{\n",libName);
#endif
  
  
  /* module init function */
  fprintf(fout,"  PyObject *m, *d, *c;\n\n");
#ifdef _WIN32
  fprintf(fout,"  static const char modulename[] = \"%s\";\n",libName);
#else
  fprintf(fout,"  static const char modulename[] = \"lib%s\";\n",libName);
#endif
  fprintf(fout,"  m = Py_InitModule((char*)modulename, Py%s_ClassMethods);\n",
    libName);

  fprintf(fout,"  d = PyModule_GetDict(m);\n");
  fprintf(fout,"  if (!d) Py_FatalError((char*)\"can't get dictionary for module %s!\");\n\n",
    libName);

  for (i = 0; i < numConcrete; i++)
    {
    fprintf(fout,"  if ((c = PyVTKClass_%sNew((char*)modulename)))\n",
      concrete[i]);
    fprintf(fout,"    if (-1 == PyDict_SetItemString(d, (char*)\"%s\", c))\n",
      concrete[i]);
    fprintf(fout,"      Py_FatalError((char*)\"can't add class %s to dictionary!\");\n\n",
      concrete[i]);
    }
  fprintf(fout,"}\n\n");
}


int main(int argc,char *argv[])
{
  FILE *file;
  FILE *fout;
  int numConcrete = 0;
  char libName[250];
  char tmpVal[250];
  char *concrete[4000];

  if (argc < 3)
    {
    fprintf(stderr,"Usage: %s input_file output_file\n",argv[0]);
    return 1;
    }

  file = fopen(argv[1],"r");
  if (!file) 
    {
    fprintf(stderr,"Input file %s could not be opened\n",argv[1]);
    return 1;
    }

  fout = fopen(argv[2],"w");
  if (!fout)
    {
    return 1;
    }

  /* read the info from the file */
  fscanf(file,"%s",libName);

  /* read in the classes */
  while (fscanf(file,"%s",tmpVal) != EOF)
    {
    concrete[numConcrete] = strdup(tmpVal);
    numConcrete++;
    }
  /* close the file */
  fclose(file);

  CreateInitFile(libName, numConcrete, concrete, fout);
  fclose(fout);

  return 0;
}

